<?php
if (!defined('ABSPATH')) exit;

add_action('admin_enqueue_scripts', function($hook_suffix) {


    if ($hook_suffix === 'mind-web_page_mind-web-chatbot-conversations') {
        wp_enqueue_script('jquery-ui-datepicker');

        wp_enqueue_style(
            'jquery-ui-css',
            'https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css'
        );
        
        wp_enqueue_style(
            'chatbot-conversations-plugin-style',
            plugin_dir_url(__DIR__) . 'assets/css/conversations.css',
            [],
            '3.3.2'
        );
        wp_enqueue_script(
            'chatbot-modal',
            plugin_dir_url(__DIR__) . 'assets/js/components/Modal.js',
            ['jquery'],
            '1.0.0',
            true
        );

        wp_enqueue_script(
            'chatbot-toast',
            plugin_dir_url(__DIR__) . 'assets/js/components/Toast.js',
            ['jquery'],
            '1.0.0',
            true
        );

         wp_enqueue_script(
            'chatbot-pagination',
            plugin_dir_url(__DIR__) . 'assets/js/components/Pagination.js',
            ['jquery'],
            '1.0.0',
            true
        );


        wp_enqueue_script(
            'chatbot-conversations-plugin-js',
            plugin_dir_url(__DIR__) . 'assets/js/conversations.js',
            ['jquery', 'jquery-ui-datepicker','chatbot-toast','chatbot-modal','chatbot-pagination'], 
            '2.3.4',
            true 
        );

        wp_localize_script(
            'chatbot-conversations-plugin-js', 
            'chatbotDataKnowledgeRepository',
            [
                'ajax_url' => admin_url('admin-ajax.php'),
                'nonce'    => wp_create_nonce('chatbot_admin_nonce')
            ]
        );
    }
});

function chatbot_plugin_chatbot_conversations_page() {
    ?>
    <div class="chatbot-conversations-wrap" id="chatbot-conversations-wrap">
        <div class="page-header">
            <div class="header-content">
                <div class="header-icon">
                    <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
                    </svg>
                </div>
                <div>
                    <h1>Chatbot Conversations</h1>
                    <p class="page-subtitle">View and analyze your chatbot interactions</p>
                </div>
            </div>
        </div>
        
        <div class="datepicker-wrapper">
            <div class="header-filter-load">
                <div class="filter-header">
                    <div class="filter-icon">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect>
                            <line x1="16" y1="2" x2="16" y2="6"></line>
                            <line x1="8" y1="2" x2="8" y2="6"></line>
                            <line x1="3" y1="10" x2="21" y2="10"></line>
                        </svg>
                    </div>
                    <h2>Filter Conversations by Date</h2>
                </div>
                <button class="btn load-convs">Load Conversations</button>
        </div>
            
            <div class="date-inputs-row">
                <div class="date-input-group">
                    <label for="start-date">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <circle cx="12" cy="12" r="10"></circle>
                            <polyline points="12 6 12 12 16 14"></polyline>
                        </svg>
                        Start Date
                    </label>
                    <input type="text" id="start-date" class="datepicker" readonly placeholder="Select start date">
                </div>
                
                <div class="date-separator">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <line x1="5" y1="12" x2="19" y2="12"></line>
                        <polyline points="12 5 19 12 12 19"></polyline>
                    </svg>
                </div>
                
                <div class="date-input-group">
                    <label for="end-date">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <circle cx="12" cy="12" r="10"></circle>
                            <polyline points="12 6 12 12 16 14"></polyline>
                        </svg>
                        End Date
                    </label>
                    <input type="text" id="end-date" class="datepicker" readonly placeholder="Select end date">
                </div>
            </div>
            
            <div class="filter-actions">
                <button id="filter-conversations" class="btn-primary">
                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <polygon points="22 3 2 3 10 12.46 10 19 14 21 14 12.46 22 3"></polygon>
                    </svg>
                    Apply Filter
                </button>
                <button id="clear-filter" class="btn-secondary">
                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <line x1="18" y1="6" x2="6" y2="18"></line>
                        <line x1="6" y1="6" x2="18" y2="18"></line>
                    </svg>
                    Clear
                </button>
                <span id="loading-spinner">
                    <span class="spinner is-active"></span>
                </span>
            </div>
        </div>
        
        <div id="conversations-results">
            <div class="empty-state">
                <svg width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                    <rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect>
                    <line x1="16" y1="2" x2="16" y2="6"></line>
                    <line x1="8" y1="2" x2="8" y2="6"></line>
                    <line x1="3" y1="10" x2="21" y2="10"></line>
                </svg>
                <h3>Select a Date Range</h3>
                <p>Choose start and end dates above to view conversations</p>
            </div>
        </div>
        
        <div id="session-modal" class="modal-overlay">
            <div class="modal-container">
                <div class="modal-header-bar">
                    <h2 class="modal-title">Session Details</h2>
                    <button id="close-modal" class="modal-close">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <line x1="18" y1="6" x2="6" y2="18"></line>
                            <line x1="6" y1="6" x2="18" y2="18"></line>
                        </svg>
                    </button>
                </div>
                <div id="modal-content" class="modal-body"></div>
            </div>
        </div>

        <!-- <div id="delete-conv-modal" class="modal-overlay">
        <div class="modal-container">
            <div class="modal-header-bar">
                <h2 class="modal-title">Delete Conversation</h2>
                <button id="close-delete-modal" class="modal-close">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <line x1="18" y1="6" x2="6" y2="18"></line>
                        <line x1="6" y1="6" x2="18" y2="18"></line>
                    </svg>
                </button>
            </div>
            <div id="modal-content" class="modal-body">
                <p>Are you sure you want to delete this conversation?</p>
                <div class="modal-actions">
                    <button id="confirm-delete-btn" class="btn btn-danger">Delete</button>
                    <button id="cancel-delete-btn" class="btn btn-secondary">Cancel</button>
                </div>
            </div>
        </div>
    </div> -->

        <div id="conversation-modal" class="modal-overlay">
            <div class="modal-container">
                <div class="modal-header-bar">
                    <h2 class="modal-title">Conversation History</h2>
                    <button id="close-conversation-modal" class="modal-close">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <line x1="18" y1="6" x2="6" y2="18"></line>
                            <line x1="6" y1="6" x2="18" y2="18"></line>
                        </svg>
                    </button>
                </div>
                <div id="conversation-modal-content" class="modal-body"></div>
            </div>
        </div>
    </div>
    
    <style>
            .ui-datepicker-header {
            background:linear-gradient(135deg, #1a365d 0%, #0f172a 100%) !important !important;
            border: none !important;
            border-radius: 8px !important;
            color: white !important;
        }
    </style>
    <?php
}