<?php
    if (!defined('ABSPATH')) exit;
    
    add_action('admin_menu', function () {

        add_menu_page(
            'Mind Web',
            'Mind Web',
            'manage_options',
            'mind-web', 
            'chatbot_plugin_mind_web_settings_page',
            'dashicons-list-view',
            25
        );

        add_submenu_page(
            'mind-web',
            'Mind Web Settings',
            'Mind Web Settings',
            'manage_options',
            'mind-web', 
            'chatbot_plugin_mind_web_settings_page'
        );
        
        add_submenu_page(
            'mind-web',
            'Mind Web Model & Usage',
            ' Model & Usage',
            'manage_options',
            'mind-web-model-usage',
            'chatbot_plugin_model_usage_page'
        );

        add_submenu_page(
            'mind-web',
            'Subscriptions',
            'Subscriptions',
            'manage_options',
            'mind-web-subscriptions',
            'chatbot_plugin_render_stripe_settings'
        );

        add_submenu_page(
            'mind-web',
            'Mind Spaces',
            'Mind Spaces',
            'manage_options',
            'mind-web-spaces',
            'chatbot_plugin_knowledge_repository_page'
        );

    add_submenu_page(
        'mind-web',                 
        'Mind Web Chatbot Conversations',       
        'Mind Web Conversations',       
        'manage_options',              
        'mind-web-chatbot-conversations',      
        'chatbot_plugin_chatbot_conversations_page' 
    );
        
    });

    add_action('admin_enqueue_scripts', function($hook_suffix) {
        if (
                $hook_suffix !== 'toplevel_page_mind-web' &&
                strpos($hook_suffix, 'mind-web_page_') !== 0
            ) {
            return;
        }
        
        wp_enqueue_style(
            'chatbot-item-style',
            plugin_dir_url(__DIR__) . 'assets/css/item_settings.css',
            [],
            '3.7.0'
        );

        wp_enqueue_style('shepherd-css', 'https://cdn.jsdelivr.net/npm/shepherd.js@8.1.0/dist/css/shepherd.css', [], '8.1.0');
        wp_enqueue_script('shepherd-js', 'https://cdn.jsdelivr.net/npm/shepherd.js@8.1.0/dist/js/shepherd.min.js', ['jquery'], '8.1.0', true);

        wp_enqueue_script(
            'chatbot-tour-js',
            plugin_dir_url(__DIR__) . 'assets/js/chatbot-tour.js',
            ['shepherd-js', 'jquery'],
            '2.0.3',
            true
        );

        wp_enqueue_style('bootstrap-icons', 'https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css', [], '1.11.1');
        wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css', [], '5.3.3');
        wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css', [], '6.4.2');

        wp_enqueue_script(
            'bootstrap-js',
            'https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js',
            ['jquery'],
            '5.3.3',
            true
        );

        wp_enqueue_script(
            'chatbot-modal',
            plugin_dir_url(__DIR__) . 'assets/js/components/Modal.js',
            ['jquery'],
            '1.0.0',
            true
        );

        wp_enqueue_script(
            'chatbot-toast',
            plugin_dir_url(__DIR__) . 'assets/js/components/Toast.js',
            ['jquery'],
            '1.0.0',
            true
        );

        wp_enqueue_script(
            'chatbot-search',
            plugin_dir_url(__DIR__) . 'assets/js/components/Search.js',
            ['jquery'],
            '1.0.0',
            true
        );

        wp_enqueue_script(
            'chatbot-index-js',
            plugin_dir_url(__DIR__) . 'assets/js/index_item.js',
            ['jquery','chatbot-modal','chatbot-toast','chatbot-search'],
            '2.3.0',
            true
        );

        wp_localize_script('chatbot-index-js', 'chatbotPlugin', [
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce'    => wp_create_nonce('chatbot_login_nonce')
        ]);
    });

    add_action('wp_enqueue_scripts', function() {
        wp_register_style('chatbot-scroll-fix', false);
        wp_enqueue_style('chatbot-scroll-fix');
        wp_add_inline_style('chatbot-scroll-fix', '
            html, body {
                overflow: auto !important;
                scroll-behavior: auto !important;
            }
        ');
    });

    add_action('admin_footer', function() {
        global $hook_suffix;
        if (
                $hook_suffix === 'toplevel_page_mind-web' ||
                strpos($hook_suffix, 'mind-web_page_') === 0
            ) {
            ?>
                <div class="help-container" style="position: fixed; bottom: 30px; right: 40px; z-index: 9999;">
                    <button id="start-tour-btn"
                            style="background: #1a365d; border: none; padding: 18px; font-size: 14px; font-weight: 600; border-radius: 50%; box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3); display: inline-flex; align-items: center; justify-content: center; gap: 8px; cursor: pointer; transition: all 0.3s; position: relative; color: #fff;"
                            onmouseover="this.style.transform='scale(1.1)'; this.style.boxShadow='0 6px 16px rgba(37, 99, 235, 0.5)';"
                            onmouseout="this.style.transform='scale(1)'; this.style.boxShadow='0 4px 12px rgba(102, 126, 234, 0.3)';">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="12" cy="12" r="10"></circle>
                            <path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"></path>
                            <path d="M12 17h.01"></path>
                        </svg>
                        <span style="position: absolute; bottom: 140%; left: 50%; transform: translateX(-50%); background: #1a365d; color: #fff; padding: 6px 10px; font-size: 13px; font-weight: 500; border-radius: 4px; white-space: nowrap; opacity: 0; pointer-events: none; transition: all 0.3s;">Need help ?</span>
                    </button>
                </div>
                
                <script>
                    jQuery(document).ready(function($){
                        $('#start-tour-btn').on('click', function(){
                            if (typeof window.tour !== 'undefined') {
                                $(this).prop('disabled', true);
                                window.tour.start();
                            }
                        });
                    });
                    const btn = document.getElementById('start-tour-btn');
                    const tooltip = btn.querySelector('span');
                    btn.addEventListener('mouseover', () => { tooltip.style.opacity = '1'; });
                    btn.addEventListener('mouseout', () => { tooltip.style.opacity = '0'; });
                </script>
            <?php
        }
    });
  

      function chatbot_plugin_mind_web_settings_page() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['chatbot_save_settings'])) {
            if (!isset($_POST['chatbot_settings_nonce']) || 
                !wp_verify_nonce($_POST['chatbot_settings_nonce'], 'chatbot_save_settings_action')) {
                wp_die('Security check failed');
            }
            update_option('chatbot_ask_setting', intval($_POST['chatbot_ask_setting']));
            update_option('chatbot_chunk_size', intval($_POST['chatbot_chunk_size']));
            update_option('chatbot_chunk_overlap', intval($_POST['chatbot_chunk_overlap']));
            update_option('chatbot_header_levels', sanitize_text_field($_POST['chatbot_header_levels']));
        
            $cat_id = intval($_POST['chatbot_category_id'] ?? 0);
            $cat_name = sanitize_text_field($_POST['chatbot_category_name'] ?? '');
            if ($cat_id && $cat_name) {
                update_option('chatbot_plugin_category', [
                    'id' => $cat_id,
                    'name' => $cat_name
                ]);
            }
            echo '<div class="notice notice-success is-dismissible d-none"><p><i class="bi bi-check-circle-fill"></i> Settings saved successfully!</p></div>';
        }

        $settings = [
            'chunk_size'    => get_option('chatbot_chunk_size', 300),
            'chunk_overlap' => get_option('chatbot_chunk_overlap', 60),
            'header_levels' => get_option('chatbot_header_levels', 'h2,h3,h4'),
            'topk'          => get_option('chatbot_ask_setting', 6),
        ];

        $total_posts = wp_count_posts('post')->publish;
        $total_pages = wp_count_posts('page')->publish;
        $total = $total_posts + $total_pages;
        $category = get_option('chatbot_plugin_category', ['id'=>'', 'name'=>'']);
        $chatbot_options = get_option('chatbot_plugin_options', []);
        $base_url = $chatbot_options['base_url'] ?? '';
        $username = $chatbot_options['username'] ?? '';

        $indexing_options = get_option('chatbot_plugin_indexing', []); 
        if (is_string($indexing_options)) {
            $indexing_options = maybe_unserialize($indexing_options);
        }

        if (!is_array($indexing_options)) {
            $indexing_options = [];
        }

        $indexing_id = $indexing_options['id'] ?? null;
        $indexing_title = $indexing_options['title'] ?? '';
        global $wpdb;
        $indexed_count = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}indexed_items");
        $current_indexing = $total - $indexed_count;
        
        ?>
         <div id="mind-web-settings-wrapper">
            <div class="wrap">
                <div class="chatbot-card" >
                    <h4 style="margin: 0; color: #fff; font-size: 25px; font-weight: 600;">
                        <i class="bi bi-sliders"></i> Indexed Item Settings
                    </h4>
                    <div class="toast-container position-fixed top-2 end-0 p-3">
                        <div id="subscription-toast" class="toast text-bg-primary border-0" role="alert">
                            <div class="d-flex">
                                <div id="subscription-toast-body" class="toast-body"></div>
                                    <button type="button" class="btn-close me-2 m-auto" data-bs-dismiss="toast"></button>
                            </div>
                        </div>
                    </div>
                </div>
                <h2 class="nav-tab-wrapper chatbot-nav-tabs">
                    <a href="#settings" class="nav-tab nav-tab-active chatbot-nav-tab" data-tab="settings">
                        <i class="bi bi-sliders"></i> General
                    </a>

                    <a href="#indexing" class="nav-tab chatbot-nav-tab" data-tab="indexing">
                        <i class="bi bi-lightning-charge-fill"></i> Indexing
                    </a>

                    <a href="#manage" class="nav-tab chatbot-nav-tab" data-tab="manage">
                        <i class="bi bi-list-check"></i> Manage Items
                    </a>

                    <a href="#technical_options" class="nav-tab chatbot-nav-tab" data-tab="technical_options">
                        <i class="bi bi-gear"></i> Technical Options
                    </a>
                </h2>

                <div id="tab-settings" class="tab-content" style="display:block;">
                    <div class="bg-white p-4 rounded shadow-sm">
                        <div class="general-info">
                            <h1 class="custom-heading fw-semibold">
                                <i class="bi bi-wrench" style="margin-right: 8px;"></i>Indexing Configuration
                            </h1>
                            <p class="text-secondary mt-2 fw-bold m-0" >Customize content indexing with chunking, headers, and category settings.</p>
                        </div>
                        <form method="post">
                            <?php wp_nonce_field('chatbot_save_settings_action', 'chatbot_settings_nonce'); ?>
                                <table class="form-table indexing-confing" style="margin-top: 15px;">
                                    <tr>
                                        <th scope="row" class="row-inputs-element">
                                            <label for="chatbot-chunk-size"><i class="bi bi-arrows-expand me-2  indexing-label"></i> Chunk Size</label>
                                        </th>
                                        <td class="settings-field">
                                            <input type="number" name="chatbot_chunk_size" id="chatbot-chunk-size" 
                                                value="<?php echo esc_attr($settings['chunk_size']); ?>" 
                                               class="settings-field-input"/>
                                            <p class="description">
                                                <i class="dashicons dashicons-info" ></i>Number of characters per chunk (default: 300)
                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th scope="row" class="row-inputs-element">
                                            <label for="chatbot-chunk-overlap"><i class="bi bi-layers me-2  indexing-label"></i> Chunk Overlap</label>
                                        </th>
                                        <td class="settings-field">
                                            <input type="number" name="chatbot_chunk_overlap" id="chatbot-chunk-overlap" 
                                                value="<?php echo esc_attr($settings['chunk_overlap']); ?>" 
                                               class="settings-field-input"/>
                                            <p class="description">
                                                <i class="dashicons dashicons-info" ></i>Overlapping characters between chunks (default: 60)
                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th scope="row" class="row-inputs-element">
                                            <label for="chatbot-header-levels"><i class="bi bi-type me-2  indexing-label"></i> Header Levels</label>
                                        </th>
                                        <td class="settings-field">
                                            <input type="text" name="chatbot_header_levels" id="chatbot-header-levels" 
                                                value="<?php echo esc_attr($settings['header_levels']); ?>" 
                                               class="settings-field-input"/>
                                            <p class="description">
                                                <i class="dashicons dashicons-info" ></i>Comma-separated header levels (e.g., h2,h3,h4)
                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th scope="row"   class="row-inputs-element">
                                            <label for="chatbot_ask_setting"><i class="bi bi-gear me-2  indexing-label"></i> Ask Configuration</label>
                                        </th>
                                        <td class="settings-field">
                                            <input 
                                                type="number" 
                                                id="chatbot_ask_setting" 
                                                name="chatbot_ask_setting"
                                                value="<?php echo esc_attr($settings['topk']); ?>" 
                                                min="1"
                                                max="20"
                                                step="1"
                                               class="settings-field-input"
                                            />
                                            <p class="description" style="margin: 8px 0 0 0; color: #64748b; font-size: 13px;">
                                                <i class="dashicons dashicons-info" ></i>
                                                Determines how many top matching results the <i class="fw-bold">Mind Web</i> assistant will consider when answering a query. 
                                            </p>
                                        </td>
                                    </tr>
                                </table>
                                <p class="submit" style="margin-top: 20px; padding-top: 15px; border-top: 1px solid #e5e7eb;">
                                    <button type="submit" name="chatbot_save_settings" class="button save-settings" id="chatbot-save-settings">
                                        <i class="bi bi-check-circle" style="margin-right: 6px;"></i>Save Settings
                                    </button>
                                </p>
                        </form>
                    </div>
                </div>

                <div id="tab-indexing" class="tab-content" style="display:none;">
                    <div class="bg-white p-4 rounded shadow-sm">
                        <div class="header-indexing" >
                            <h1 class="custom-heading fw-semibold">
                                <i class="bi bi-lightning-charge-fill" style="margin-right: 8px;"></i>Content Indexing Status
                            </h1>
                            <p class="text-secondary mt-2 fw-bold mb-0">
                                View and manage the indexing progress of your posts and pages.  
                            </p>
                        </div>
                        <div class="indexing-status">
                            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(150px, 1fr)); gap: 15px;">
                                <div>
                                    <div class="indexing-elements-progress">Total Posts & Pages</div>
                                    <div style="font-size: 24px; font-weight: 700; color: #1a365d;"><?php echo $total; ?></div>
                                </div>
                                <div>
                                    <div class="indexing-elements-progress">Not Indexed</div>
                                    <div id="to-index-count" style="font-size: 24px; font-weight: 700; color: #1a365d;"><?php echo $current_indexing; ?></div>
                                </div>
                                <div>
                                    <div class="indexing-elements-progress">Indexed</div>
                                    <div id="indexed-count" style="font-size: 24px; font-weight: 700; color: #10b981;"><?php echo $indexed_count; ?></div>
                                </div>
                                <div>
                                    <div class="indexing-elements-progress">Progress</div>
                                    <div id="index-progress" style="font-size: 24px; font-weight: 700; color: #1a365d; ">0%</div>
                                </div>
                            </div>
                        </div>
                        <button id="chatbot-index-all-items" class="button">
                            <i class="bi bi-play-circle-fill" style="font-size: 16px;"></i>
                            <span>Start Indexing</span>
                        </button>
                        <div id="progress-container" style="display:none; margin-top: 20px;">
                            <div style="background: #f1f5f9; height: 30px; border-radius: 15px; overflow: hidden; position: relative;">
                                <div id="progress-bar" style="background:linear-gradient(135deg, #1a365d 0%, #0f172a 100%) !important height: 100%; width: 0%; transition: width 0.3s; display: flex; align-items: center; justify-content: center; color: white; font-weight: 600; font-size: 13px;">
                                    <span id="progress-text">0%</span>
                                </div>
                            </div>
                            <div id="progress-status"></div>
                        </div>
                        <div id="chatbot-index-all-result" style="margin-top:20px;"></div>
                    </div>
                </div>

                <div id="tab-manage" class="tab-content" style="display:none;">
                    <div class="bg-white p-4 rounded shadow-sm">
                        <div class="wrap">
                            <div class="d-flex align-items-center border-bottom pb-3">
                                <div class="flex-grow-1">
                                    <h1 class="fw-semibold m-0">
                                        <i class="bi bi-list-check me-2 text-primary"></i>
                                        All Indexed Items
                                    </h1>
                                    <p class="text-secondary fw-bold m-0 mt-1">
                                        A complete list of all successfully indexed items.
                                    </p>
                                </div>
                                
                                <div class="search-wrapper flex-shrink-0 mx-4 position-relative" style="width: 450px;">
                                    <i class="bi bi-search position-absolute text-muted" 
                                    style="left: 12px; top: 50%; transform: translateY(-50%); pointer-events: none;"></i>
                                    <input
                                        type="text"
                                        class="form-control ps-5"
                                        id="search-input"
                                        placeholder="Search indexed items..."
                                        aria-label="Search indexed items"
                                    >
                                </div>
                                
                                <div class="flex-grow-1 d-flex justify-content-end gap-2">
                                    <button 
                                        id="chatbot-unindex-all-items"
                                        class="btn btn-danger d-flex align-items-center gap-2 px-3"
                                        aria-label="Unindex all items">
                                        <i class="bi bi-trash-fill"></i>
                                        <span>Unindex All</span>
                                    </button>
                                    <button
                                        class="btn btn-success btn-index-items d-flex align-items-center gap-2 px-3"
                                        aria-label="Index new items">
                                        <i class="bi bi-check-circle-fill"></i>
                                        <span>Index Items</span>
                                    </button>
                                </div>
                            </div>
                           <div id="chatbot-unindex-result" class="mb-3"></div>
                           <div class="table-responsive border custom-rounded" style="border-color: #e5e7eb;">
                               <table id="table-indexed" class="wp-list-table widefat fixed striped m-0">
                                    <thead >
                                        <tr>
                                            <th class= "table-indexed-title">ID</th>
                                            <th class= "table-indexed-title" >Item ID</th>
                                            <th class= "table-indexed-title">Post ID</th>
                                            <th class= "table-indexed-title">Category</th>
                                            <th class= "table-indexed-title">Author</th>
                                            <th class= "table-indexed-title">Title</th>
                                            <th class= "table-indexed-title" >Name</th>
                                            <th class= "table-indexed-title">Status</th>
                                            <th class= "table-indexed-title">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
                            <div id="pagination"></div> 
                        </div>
                    </div>
                </div>

                <div id="tab-technical_options" class="tab-content" style="display:none;">
                    <div class="bg-white p-4 rounded shadow-sm">
                        <div class="technical-option">
                        <h1 class="custom-heading fw-semibold">
                            <i class="bi bi-tools" style="margin-right: 6px;"></i>Technical Options
                        </h1>
                            <p class="text-secondary mt-2 fw-bold mb-0">
                                Review your technical settings including URLs, credentials, indexing, and system configuration.          
                            </p>
                        </div>
                        <table class="form-table" style="margin-top: 15px;">
                            <tr>
                                <th scope="row"   class="row-inputs-element">
                                    <label for="chatbot-chunk-size"><i class="bi bi-link-45deg me-2 techinical-indexing"></i> Base Url:</label>
                                </th>
                                <td class="settings-field">
                                    <input type="text" name="chatbot_base_url" id="chatbot-base-url" 
                                        value="<?php echo esc_attr($base_url); ?>" readonly
                                       class="settings-field-input"/>
                                    <p class="description">
                                         <i class="dashicons dashicons-info" ></i> The foundational URL that anchors all system connections.
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row"  class="row-inputs-element">
                                    <label for="username"><i class="bi bi-person-circle me-2 techinical-indexing"></i> Username:</label>
                                </th>
                                <td class="settings-field">
                                    <input type="text" name="username" id="username" 
                                        value="<?php echo esc_attr($username); ?> " readonly 
                                       class="settings-field-input"/>
                                    <p class="description" style="color: #64748b; margin-top: 5px; font-size: 13px;">
                                         <i class="dashicons dashicons-info" ></i> Name assigned to identify the user.
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row"  class="row-inputs-element">
                                    <label for="chatbot-indexing-id"><i class="bi bi-hash me-2 techinical-indexing"></i>Indexing Id:</label>
                                </th>
                                <td class="settings-field">
                                    <input type="text" name="chatbot_indexing_id" id="chatbot-indexing-id" 
                                        value="<?php echo esc_attr($indexing_id); ?>" readonly 
                                       class="settings-field-input"/>
                                    <p class="description">
                                         <i class="dashicons dashicons-info" ></i> Identifier for data indexing.
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row"   class="row-inputs-element">
                                    <label for="chatbot-indexing-title"><i class="bi bi-card-heading me-2 techinical-indexing"></i> Indexing Title:</label>
                                </th>
                                <td class="settings-field">
                                    <input type="text" name="chatbot_indexing_title" id="chatbot-indexing-title" 
                                        value="<?php echo esc_attr($indexing_title); ?>" readonly 
                                       class="settings-field-input"/>
                                    <p class="description">
                                         <i class="dashicons dashicons-info" ></i> Title for this indexing setup.
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row"   class="row-inputs-element">
                                    <label for="chatbot-category-id"><i class="bi bi-tags me-2 techinical-indexing"></i> Category:</label>
                                </th>
                                <td class="settings-field">
                                    <div class="d-flex gap-2" class="category-info">
                                        <input type="number" id="chatbot-category-id" name="chatbot_category_id"
                                            value="<?php echo esc_attr($category['id']); ?>" 
                                            placeholder="ID" readonly 
                                            class="settings-field-input"/>
                                        <input type="text" id="chatbot-category-name" name="chatbot_category_name"
                                            value="<?php echo esc_attr($category['name']); ?>" 
                                            placeholder="Category Name" readonly 
                                            class="settings-field-input"/>
                                    </div>
                                    <p class="description">
                                        <i class="dashicons dashicons-info" ></i> Category ID and Name for indexing.
                                    </p>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>

                <div class="modal fade" id="unindex-item" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="unindexItemModalTitle"></h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                            </div>
                            <div class="modal-body" id="unindexItemModalBody"></div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                <button type="button" id="unindexItemModalConfirm" class="btn"></button>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
</div>
        <?php
    }
?>
