<?php
    if (!defined('ABSPATH')) exit;
    
    add_action('admin_enqueue_scripts', function($hook_suffix) {
        wp_enqueue_style(
            'chatbot-knowledge-repository-style',
            plugin_dir_url(__DIR__) . 'assets/css/knowledge_repository.css',
            [],
            '3.3.0'
        );

        wp_enqueue_script(
            'chatbot-pagination',
            plugin_dir_url(__DIR__) . 'assets/js/components/Pagination.js',
            ['jquery'],
            '1.0.0',
            true
        );

        wp_enqueue_script(
            'chatbot-toast',
            plugin_dir_url(__DIR__) . 'assets/js/components/Toast.js',
            ['jquery'],
            '1.0.0',
            true
        );

        if ($hook_suffix === 'mind-web_page_mind-web-spaces') {
            wp_enqueue_script(
                'chatbot-knowledge-repository-js',
                plugin_dir_url(__DIR__) . 'assets/js/knowledge_repository.js',
                ['jquery','chatbot-pagination','chatbot-toast'], 
                '2.3.0',
                true 
            );
    
            wp_localize_script(
                'chatbot-knowledge-repository-js', 
                'chatbotDataKnowledgeRepository',
                [
                    'ajax_url' => admin_url('admin-ajax.php'),
                    'nonce'    => wp_create_nonce('chatbot_login_nonce')
                ]
            );
        }
    });
    
    function chatbot_plugin_knowledge_repository_page() {
        $knowledge_repository_options = get_option('chatbot_knowledge_repository_options', []);
        ?>
         <div id="mind-spaces-wrapper">
            <div class="wrap chatbot-knowledge-wrapper" style="max-width: 100%; padding: 0px 20px 40px 20px;">
                <div class="chatbot-card-knowledge">
                      <h4 style="margin: 0; color: #fff; font-size: 25px; font-weight: 600;"> <i class="bi bi-sliders"></i> Mind Spaces Settings</h4>
                </div>
                <div class="toast-container position-fixed end-0 " style="z-index: 1060; margin-right: 80px;">
                    <div id="subscription-toast" class="toast text-bg-primary border-0" role="alert">
                        <div class="d-flex">
                            <div id="subscription-toast-body" class="toast-body"></div>
                            <button type="button" class="btn-close me-2 m-auto" data-bs-dismiss="toast"></button>
                        </div>
                    </div>
                </div>
                <h2 class="nav-tab-wrapper chatbot-nav-tabs">
                    <a href="#general" class="nav-tab nav-tab-active chatbot-nav-tab" data-tab="general"><i class="bi bi-sliders"></i> General</a>
                    <a href="#page_based_notebooks" class="nav-tab chatbot-nav-tab" data-tab="page_based_notebooks" id="page-based-notebooks-tab"><i class="bi bi-journal-text"></i> Mind Spaces Page Based Notebooks</a>
                </h2>

                <div id="tab-general" class="tab-content" style="display:block;">
                    <div class="chatbot-card p-5 mx-auto mt-5" style="
                        max-width: 700px; 
                        background: #fff; 
                        border-radius: 12px; 
                        box-shadow: 0 8px 20px rgba(0,0,0,0.08);">

                        <div style="text-align: center;">
                            <h2 style="margin: 0; font-weight: 700; color: #1e293b;">
                                <i class="bi bi-lightbulb me-2" style="color:#1a365d;"></i> Mind Spaces Login
                            </h2>
                            <p style="margin-top: 10px; color: #6b7280; font-size: 16px;">
                                Enter your credentials to access your account.
                            </p>
                        </div>
                        
                        <table class="form-table chatbot-knowledge-repository w-100 mb-3">
                            <tr>
                                <th style="width:30%;"><i class="bi bi-link-45deg"></i> Base URL</th>
                                <td>
                                    <input type="text" 
                                        id="chatbot-base-url" 
                                        class="form-control"
                                        value="<?php echo esc_attr($knowledge_repository_options['base_url'] ?? 'https://spaces.mind.smartprocesses.cloud'); ?>">
                                </td>
                            </tr>
                            <tr>
                                <th><i class="bi bi-person"></i> Username</th>
                                <td class="d-flex flex-column">
                                    <input type="text" 
                                        id="chatbot-username" 
                                        class="form-control"
                                        autocomplete="off"
                                        placeholder="name@example.com" 
                                        value="<?php echo esc_attr($knowledge_repository_options['username']); ?>">
                                    <span class="text-danger small d-none username-error"></span>
                                </td>
                            </tr>
                            <tr>
                                <th><i class="bi bi-lock"></i> Password</th>
                                <td class="d-flex flex-column">
                                    <div class="password-wrapper position-relative">
                                        <input type="password" 
                                            id="chatbot-password" 
                                            class="form-control"
                                            autocomplete="new-password"
                                            placeholder="******" 
                                            value="<?php echo esc_attr($knowledge_repository_options['password'] ?? ''); ?>">
                                        <i class="bi bi-eye-fill eye-icon position-absolute" id="toggle-password-visibility" style="top: 50%; right: 10px; transform: translateY(-50%); cursor: pointer;"></i> 
                                    </div>
                                    <span class="text-danger small d-none password-error"></span>
                                </td>
                            </tr>
                        </table>
                        
                        <div class="text-center mt-4">
                            <div class="login-btn-index_link" id="login-btn-index_link">
                                <button id="chatbot-knowledge-repository-login-btn" class="btn btn-primary w-50 py-2">Log in</button>                
                                <p class="mt-3 mb-0 small text-muted">
                                    Don't have an account? 
                                    <a href="https://spaces.mind.smartprocesses.cloud/Identity/Account/Register" target="_blank">Sign up here</a>
                                </p>
                            </div>
                            
                            <div class="log-out d-flex justify-content-center" id="log-out"> 
                                <button class="chatbot-knowledge-repository-sign-out btn btn-danger w-50 py-2 d-none" id="chatbot-knowledge-repository-sign-out"> 
                                    <span>Log out
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16px" height="16px" viewBox="0 0 24 24" fill="none" stroke="#ffffff">
                                            <g id="SVGRepo_bgCarrier" stroke-width="0"/>
                                            <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/>
                                            <g id="SVGRepo_iconCarrier"> 
                                                <path d="M21 12L13 12" stroke="#ffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> 
                                                <path d="M18 15L20.913 12.087V12.087C20.961 12.039 20.961 11.961 20.913 11.913V11.913L18 9" stroke="#ffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> 
                                                <path d="M16 5V4.5V4.5C16 3.67157 15.3284 3 14.5 3H5C3.89543 3 3 3.89543 3 5V19C3 20.1046 3.89543 21 5 21H14.5C15.3284 21 16 20.3284 16 19.5V19.5V19" stroke="#ffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> 
                                            </g>
                                        </svg>
                                    </span> 
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <div id="tab-page_based_notebooks" class="tab-content" style="display:none;">
                    <div class="chatbot-card">
                        <div class="notebooks-container">
                            <div class="notebooks-header">
                                <div class="notebooks-title-wrapper">
                                    <div class="notebook-header-title">
                                        <h1 class="notebooks-title">📚 Mind Spaces Page Knowledge Base</h1> 
                                        <p class="notebooks-subtitle">All spaces linked for page.</p>
                                    </div>  
                                    <div class="flex-shrink-0 mx-4 position-relative" style="width: 450px;">
                                        <i class="bi bi-search position-absolute text-muted" 
                                        style="left: 12px; top: 50%; transform: translateY(-50%); pointer-events: none;"></i>
                                        <input
                                            type="text"
                                            class="form-control ps-5"
                                            id="search-input-page-notebooks"
                                            placeholder="Search Page Knowledge Base..."
                                            aria-label="Search Page Knowledge Base"
                                        >
                                    </div>                               
                                </div>
                            </div>
                            
                            <div class="d-flex justify-content-center my-4 " style="gap: 20px;">
                                <button id="add-page-based-notebook" class="btn btn-primary">
                                    <i class="bi bi-plus" style="margin-right: 5px;"></i>
                                    Knowledge base / reference
                                </button>
                                                            
                                <button id="remove-all-page-notebooks" class="btn btn-danger btn-sm">
                                    <i class="bi bi-trash3" style="margin-right: 5px;"></i>
                                    Remove All Page Spaces
                                </button>
                            </div>
                        </div>
                    </div>
                    
                </div>

            </div>
            <div class="modal fade" id="pageBasedNotebookModal" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl modal-dialog-scrollable">
                    <div class="modal-content">
                        <div class="modal-header text-white">
                            <div>
                                <h5 class="modal-title mb-1">
                                    <i class="bi bi-journal-text me-2"></i>
                                    Mind Spaces Knowledge Base / Reference
                                </h5>
                                <small class="opacity-75">Select posts and pages to add to your <i class="fw-bold">Mind Spaces</i> base</small>
                            </div>
                            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-header bg-light border-bottom">
                            <div class="d-flex align-items-center gap-3 w-100 header-select-search">
                                <div class="form-check" style="display:flex; align-items:baseline; gap:5px;">
                                    <input class="form-check-input" type="checkbox" id="select-all-pages">
                                    <label class="form-check-label fw-semibold select-all text-info" for="select-all-pages">
                                        Select All
                                    </label>
                                </div>
                                <div class="search-container"> 
                                    <input type="text" class="search-input-glass" id="search-input" placeholder="Search anything...">
                                </div>
                            </div>
                        </div>
                        <div class="modal-body" style="max-height: 60vh; overflow-y: auto;">
                            <div class="text-center py-5">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer bg-light">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <i class="bi bi-x-circle me-1"></i>
                            Cancel
                            </button>
                            <button type="button" class="btn btn-primary" id="save-selected-pages" disabled>
                            <i class="bi bi-check-circle me-1"></i>
                            Add Selected
                            </button>                                                                                                                   
                        </div>
                    </div>
                </div>
            </div>

            <div class="modal fade" id="confirmActionModal" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="confirmModalTitle">Confirm action</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body" id="confirmModalBody">
                            Are you sure you want to continue?
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                                Cancel
                            </button>
                            <button type="button" class="btn btn-danger" id="confirmModalBtn">
                                Confirm
                            </button>
                        </div>
                    </div>
                </div>
            </div>
</div>
        <?php
    }
?>