<?php
if (!defined('ABSPATH')) {
    exit;
}

add_action('admin_enqueue_scripts', function($hook_suffix) {
    wp_enqueue_style(
        'chatbot-model-usage-style',
        plugin_dir_url(__DIR__) . 'assets/css/model_usage.css',
        [],
        '3.3.0'
    );

    wp_enqueue_script(
            'chatbot-toast',
            plugin_dir_url(__DIR__) . 'assets/js/components/Toast.js',
            ['jquery'],
            '1.0.0',
            true
        );

    if ($hook_suffix === 'mind-web_page_mind-web-model-usage') {
        wp_enqueue_script(
            'chatbot-model-usage-js',
            plugin_dir_url(__DIR__) . 'assets/js/chatbot_create_attach_llm_config.js',
            ['jquery','chatbot-toast'],
            '2.3.0',
            true
        );

        wp_localize_script(
            'chatbot-model-usage-js',
            'chatbotModelUsage',
            [
                'ajax_url' => admin_url('admin-ajax.php'),
                'nonce'    => wp_create_nonce('chatbot_login_nonce')
            ]
        );
    }
});


function chatbot_plugin_model_usage_page() {
    $api_settings = [
        'name'        => get_option('chatbot_api_llm_name', ''),
        'base_url'    => get_option('chatbot_api_base_url_llm', ''),
        'model_name'  => get_option('chatbot_api_model_name', ''),
        'provider'    => get_option('chatbot_api_provider', ''),
        'api_key'     => get_option('chatbot_api_key', ''),
    ];
    ?>

    <div class="wrap chatbot-model-usage-wrapper">
        <div class="chatbot-header-card">
              <h4 style="margin: 0; color: #fff; font-size: 25px; font-weight: 600;"> <i class="bi bi-sliders"></i> Mind Web Model & Usage</h4>
        </div>
        <h2 class="nav-tab-wrapper chatbot-nav-tabs">
            <a href="#build_model" class="nav-tab nav-tab-active chatbot-nav-tab" data-tab="build_model">
                <i class="bi bi-sliders"></i> Build a Model
            </a>
            <a href="#openai_provider" class="nav-tab chatbot-nav-tab" data-tab="openai_provider" data-provider="openai">
                <i class="bi bi-journal-text"></i> OpenAI
            </a>
        </h2>

        <div id="tab-build_model" class="tab-content build-model-wrapper" style="display: block;">
            <div class="build-model-info">
                <div class="build-model-header">
                    <i class="bi bi-robot"></i>
                    <h2>You are using OpenAI Model</h2>
                </div>

                <div class="build-model-content">
                    <p>
                        All model configurations and settings are managed through the <strong>OpenAI</strong> tab.
                    </p>
                    <p>
                        Click on the <strong>OpenAI</strong> tab above to configure your model settings, API keys, and other options.
                    </p>
                </div>

                <div class="build-model-actions">
                    <button type="button" class="button-large-action go-to-tab-btn" data-tab="openai_provider">
                        <i class="bi bi-arrow-right-circle"></i>
                        Go to OpenAI Configuration
                    </button>
                </div>
            </div>
        </div>

        <div id="tab-openai_provider" class="tab-content" style="display: none;">
            <div class="config-header-wrapper">
                <div class="config-header-info">
                    <h2>
                        <i class="bi bi-wrench"></i>
                        OpenAI Configuration
                    </h2>
                    <p class="tab-subtitle">
                        Create and attach an OpenAI LLM configuration
                    </p>
                </div>

                <div class="config-header-actions">
                    <button type="button" class="btn btn-update-llm">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="-2.4 -2.4 28.80 28.80" fill="none" style="margin-right: 8px;">
                            <g id="SVGRepo_bgCarrier" stroke-width="0"/>
                            <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round" stroke="#CCCCCC" stroke-width="0.336"/>
                            <g id="SVGRepo_iconCarrier">
                                <path d="M18.3785 8.44975L11.4637 15.3647C11.1845 15.6439 10.8289 15.8342 10.4417 15.9117L7.49994 16.5L8.08829 13.5582C8.16572 13.1711 8.35603 12.8155 8.63522 12.5363L15.5501 5.62132M18.3785 8.44975L19.7927 7.03553C20.1832 6.64501 20.1832 6.01184 19.7927 5.62132L18.3785 4.20711C17.988 3.81658 17.3548 3.81658 16.9643 4.20711L15.5501 5.62132M18.3785 8.44975L15.5501 5.62132" stroke="#0073aa" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M5 20H19" stroke="#0073aa" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                            </g>
                        </svg>
                        <span>Edit</span>
                    </button>
                    <button class="btn btn-success btn-save-changes d-none" id="llm-save-changes">
                        <i class="bi bi-check-circle"></i>
                        Save Changes
                    </button>
                </div>
            </div>

            <form method="post" id="llm-config-form">
                <?php wp_nonce_field('chatbot_api_llm_settings_action', 'chatbot_api_llm_settings_nonce'); ?>

                <table class="form-table">
                    <tbody>
                        <tr>
                            <th scope="row">
                                <label for="api-llm-name">
                                    <i class="bi bi-tag"></i>
                                    Name
                                </label>
                            </th>
                            <td>
                                <input
                                    type="text"
                                    name="name"
                                    id="api-llm-name"
                                    class="form-input"
                                    value="<?php echo esc_attr($api_settings['name']); ?>"
                                    placeholder="e.g., Production GPT-4, Dev Claude"
                                />
                                <p class="description">
                                    <i class="dashicons dashicons-info"></i>
                                    <span>Give this LLM configuration a memorable name to easily identify it later</span>
                                </p>
                            </td>
                        </tr>

                        <tr>
                            <th scope="row">
                                <label for="api-base-url-llm">
                                    <i class="bi bi-link-45deg"></i>
                                    Base URL
                                </label>
                            </th>
                            <td>
                                <input
                                    type="url"
                                    name="llm_base_url"
                                    id="api-base-url-llm"
                                    class="form-input"
                                    value="<?php echo esc_attr($api_settings['base_url']); ?>"
                                    placeholder="https://api.openai.com/v1/"
                                />
                                <p class="description">
                                    <i class="dashicons dashicons-info"></i>
                                    <span>The API endpoint URL provided by your LLM provider (must include protocol https://)</span>
                                </p>
                            </td>
                        </tr>

                        <tr>
                            <th scope="row">
                                <label for="api-model-name">
                                    <i class="bi bi-cpu"></i>
                                    Model Name
                                </label>
                            </th>
                            <td>
                                <input
                                    type="text"
                                    name="model_name"
                                    id="api-model-name"
                                    class="form-input"
                                    value="<?php echo esc_attr($api_settings['model_name']); ?>"
                                    placeholder="e.g., gpt-4-turbo, claude-3-opus"
                                />
                                <p class="description">
                                    <i class="dashicons dashicons-info"></i>
                                    <span>Specify the exact model identifier as defined by your provider's API documentation</span>
                                </p>
                            </td>
                        </tr>

                        <tr class="d-none">
                            <th scope="row">
                                <label for="api-provider">
                                    <i class="bi bi-building"></i>
                                    Provider
                                </label>
                            </th>
                            <td>
                                <input
                                    type="text"
                                    name="provider"
                                    id="api-provider"
                                    class="form-input"
                                    value="<?php echo esc_attr($api_settings['provider']); ?>"
                                    readonly
                                />
                                <p class="description">
                                    <i class="dashicons dashicons-info"></i>
                                    <span>Provider is selected automatically based on the active tab</span>
                                </p>
                            </td>
                        </tr>

                        <tr>
                            <th scope="row">
                                <label for="api-key">
                                    <i class="bi bi-key"></i>
                                    API Key
                                </label>
                            </th>
                            <td>
                                <div class="input-wrapper">
                                    <input
                                        type="password"
                                        name="api_key"
                                        id="api-key"
                                        class="form-input"
                                        value="<?php echo esc_attr($api_settings['api_key']); ?>"
                                        placeholder="sk-••••••••••••••••"
                                    />
                                    <button type="button" id="toggle-api-key" class="toggle-password-btn">
                                        <i class="bi bi-eye" id="eye-icon"></i>
                                    </button>
                                </div>
                                <p class="description">
                                    <i class="dashicons dashicons-info"></i>
                                    <span>Enter your private API authentication key. This will be encrypted and stored securely in the database</span>
                                </p>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <div class="submit-section">
                    <button type="submit" class="button-primary-llm-config" id="chatbot-connect-api">
                        <svg width="18" height="18" viewBox="0 0 24 24" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
                            <path d="M7 2v6H5v4a7 7 0 0014 0V8h-2V2h-2v6H9V2H7zm0 10V10h10v2a5 5 0 01-10 0z"/>
                        </svg>
                        <span>Connect LLM</span>
                    </button>
                    <button type="button" class="btn btn-danger btn-disconnect-llm d-none" id="chatbot-llm-disconnect-api">
                        <svg width="18" height="18" viewBox="0 0 24 24" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
                            <path d="M7 2v6H5v4c0 1.5.5 2.9 1.3 4L3 19l2 2 3.2-3.2A7 7 0 0019 12V8h-2V2h-2v6H9V2H7zm0 10V10h10v2a5 5 0 01-8.9 3.1l1.4-1.4A3 3 0 0017 12v-2H7z"/>
                        </svg>
                        <span>Disconnect LLM</span>
                    </button>
                </div>
            </form>
        </div>

        <div class="modal fade" id="disconnectLlm" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="disconnectLlmModalTitile"></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body" id="disconnectLlmModalBody"></div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="button" id="disconnectLlmModalConfirm" class="btn"></button>
                    </div>
                </div>
            </div>
        </div> 
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const toggleBtn = document.getElementById('toggle-api-key');
            if (toggleBtn) {
                toggleBtn.addEventListener('click', function() {
                    const apiKeyInput = document.getElementById('api-key');
                    const eyeIcon = document.getElementById('eye-icon');
                    
                    if (apiKeyInput.type === 'password') {
                        apiKeyInput.type = 'text';
                        eyeIcon.classList.remove('bi-eye');
                        eyeIcon.classList.add('bi-eye-slash');
                    } else {
                        apiKeyInput.type = 'password';
                        eyeIcon.classList.remove('bi-eye-slash');
                        eyeIcon.classList.add('bi-eye');
                    }
                });
            }
        });
    </script>
    <?php
}

