<?php
    if (!defined('ABSPATH')) exit;
    require_once dirname(__DIR__) . '/includes/db.php';
    $config_path = dirname(__DIR__) . '/config.json';
    $config = [];

    if (file_exists($config_path)) {
        $config = json_decode(file_get_contents($config_path), true);
    }

    global  $prod_id;
    $prod_id = sanitize_text_field($config['prod_id'] ?? 'prod_TV5yFBE7tEW4LN');

    add_action('admin_init', 'chatbot_stripe_init_settings');
    add_action('admin_enqueue_scripts', function($hook) {
        $app_guid = get_option('chatbot_plugin_guid');
        $stripe_base_url = chatbot_get_stripe_base_url();
        $trial_option = maybe_unserialize(get_option('chatbot_trial_response', []));
        if (!is_array($trial_option)) $trial_option = [];
        $subscription = $trial_option['subscription'] ?? $trial_option;
        $endDate = isset($subscription['currentPeriodEnd']) ? date("Y-m-d H:i:s", strtotime($subscription['currentPeriodEnd'])) : '';
        $startDate = isset($subscription['createdAt']) ? substr($subscription['createdAt'], 0, 10) : '';
        $type = $subscription['type'] ?? '';
        $status = $subscription['status'] ?? '';
        
        if($hook !== 'mind-web_page_mind-web-subscriptions') return;
        
        $product_id = get_option('chatbot_stripe_product_id','');
        $user = wp_get_current_user();
        $user_email = $user->user_email;
    
        wp_enqueue_style(
            'chatbot-stripe-style',
            plugin_dir_url(__DIR__) . 'assets/css/stripe.css',
            [],
            '3.3.1'
        );

        wp_enqueue_script(
            'chatbot-modal',
            plugin_dir_url(__DIR__) . 'assets/js/components/Modal.js',
            ['jquery'],
            '1.0.0',
            true
        );

        wp_enqueue_script(
            'chatbot-toast',
            plugin_dir_url(__DIR__) . 'assets/js/components/Toast.js',
            ['jquery'],
            '1.0.0',
            true
        );
    
        wp_enqueue_script(
            'chatbot-frontend',
            plugin_dir_url(__DIR__) . 'assets/js/chatbot-frontend.js',
            ['jquery', 'chatbot-modal', 'chatbot-toast'], 
            '1.0.0',
            true
        );
    
        wp_localize_script('chatbot-frontend', 'chatbotData', [
            'ajaxurl' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('chatbot_trial_nonce'),
            'trialEndDate' => $endDate,
            'stripe_base_url' => chatbot_get_stripe_base_url(),
            'app_guid' => $app_guid,
            'product_id' => $product_id,
            'trial_status' => $status,
            'trial_type' => $type,
            'user_email' => $user_email,
            'title' => get_option('siteurl')
        ]);
    });
    
    
    function chatbot_stripe_init_settings() {
        global $prod_id;
        if (!$prod_id) return;
        $current = get_option('chatbot_stripe_product_id');
        if ($current !== $prod_id) {
            update_option('chatbot_stripe_product_id', $prod_id);
        }
    }

    
    function chatbot_plugin_render_stripe_settings() {
        if (!current_user_can('manage_options')) {
            wp_die(__('You do not have sufficient permissions to access this page.'));
        }
    
        $product_id = get_option('chatbot_stripe_product_id', 'prod_TV5yFBE7tEW4LN');
        $stripe_base_url = chatbot_get_stripe_base_url();
        $trial_option =  maybe_unserialize(get_option('chatbot_trial_response', []));
        
        if (!is_array($trial_option)) {
            $trial_option = [];
        }
        
        $endDate = isset($trial_option['currentPeriodEnd']) ? date("Y-m-d H:i:s", strtotime($trial_option['currentPeriodEnd'])) : '';
        $startDate = isset($trial_option['createdAt']) ? substr($trial_option['createdAt'], 0, 10) : '';
        $type = $trial_option['type'] ?? '';
        $status = $trial_option['status'] ?? '';
        $guid = get_option('chatbot_plugin_guid', '');
        $site_title = get_option('siteurl');

        ?>
        <div id="chatbot-stripe-settings-wrapper">
            <div class="wrap chatbot-stripe-settings" style="padding: 0px 20px 40px 20px;">
                <div class="chatbot-card-subscriptions">
                     <h4 style="margin: 0; color: #fff; font-size: 25px; font-weight: 600;">
                       <i class="bi bi-sliders"></i>  Subscriptions Overview
                    </h4>
                </div>
                
                <h2 class="nav-tab-wrapper chatbot-nav-tabs">
                    <a href="#settings" class="nav-tab nav-tab-active chatbot-nav-tab" data-tab="settings"><i class="bi bi-sliders"></i> General</a>
                    <a href="#subscriptions" class="nav-tab chatbot-nav-tab" data-tab="subscriptions" id="subscription-tab"><i class="bi bi-credit-card-2-front"></i> Subscriptions Overview</a>
                    <a href="#logs" class="nav-tab chatbot-nav-tab" data-tab="logs" id="logs-tab"><i class="bi bi-clock-history"></i> Subscriptions History</a>
                </h2>

                <div id="tab-settings" class="tab-content" style="display:block;">
                    <div class="chatbot-card">
                        <form method="post">
                            <?php wp_nonce_field('chatbot_stripe_settings_nonce'); ?>  
                            <table class="form-table">
                                <div class="subscription-info-block">
                                    <h1 class="custom-heading fw-semibold"> <i class="bi bi-sliders" style="margin-right: 6px;"></i>  Plugin Identifier and Site Address</h1>
                                    <p class="text-secondary mt-2 fw-bold m-0 paragraph-info">Shows the unique plugin GUID and the site URL for this Mind Web.</p>
                                    <p class="text-warning fw-bold">⚠️ 7-DAY TRIAL WARNING </br>
                                        Your free trial ends soon. After 7 days, chat and all features will be disabled, but your configuration stays safe and unchanged. Upgrade anytime to regain full access instantly.
                                    </p>                  
                                </div>
                                <tr>
                                    <th scope="row"><i class="bi bi-key"></i> Plugin GUID:</th>
                                    <td>
                                        <input 
                                            type="text" 
                                            id="chatbot-guid" 
                                            value="<?php echo esc_attr($guid); ?>" 
                                            readonly
                                            class="regular-text"
                                            />
                                        <p class="description">Your plugin identifier guid.</p>
                                    </td>
                                </tr>
                                <tr>
                                    <th scope="row"><i class="bi bi-globe"></i> Site Url:</th>
                                    <td>
                                        <input 
                                            type="text" 
                                            id="site-url" 
                                            value="<?php echo esc_attr($site_title); ?>"
                                            readonly
                                            class="regular-text"
                                            />
                                        <p class="description">Site Url.</p>
                                    </td>
                                </tr>
                            </table>
                        </form>
                    </div>
                </div>

                <div id="tab-subscriptions" class="tab-content" style="display:none;"> 
                    <div class="chatbot-card">
                        <div class="subscription-info-block">
                            <h1 class="custom-heading fw-semibold"><i class="bi bi-credit-card-2-front" style="margin-right: 6px;"></i> Subscription Overview</h1>
                            <p class="text-secondary fw-bold m-0 paragraph-info">
                                Summary of your current trial subscription period and status.
                            </p>
                        </div>
                        <div class="subscription-header-wrapper">
                            <div id="btn-buy-wrapper"></div>
                            <button type="button" id="refresh-plugin" class="btn-buy-trial" style="background:#1a365d; display:none; align-items:center; gap:8px;">
                                <i class="bi bi-arrow-clockwise"></i>
                                <p>Refresh Subscription Status</p>
                            </button>
                        </div>

                        <div id="chatbot-subscription-result" style="margin-top:10px; color:#d63638;"></div>
                        <div id="subscription-cards-container" class="subscription-cards-grid">
                        </div>
                    </div>
                </div>

                <div id="tab-logs" class="tab-content" style="display:none;">
                    <div class="chatbot-card">
                        <div class="subscription-info-block">
                            <h1 class="custom-heading fw-semibold"><i class="bi bi-clock-history" style="margin-right: 6px;"></i> Subscription History</h1>
                            <p class="text-secondary fw-bold m-0 paragraph-info">Keep track of your subscription history and quickly review all important updates and messages.</p>
                        </div>
                        <div id="logs-cards-container" class="logs-cards-grid">
                        </div>
                    </div>
                </div>

                <div class="modal fade" id="subscriptionActionModal" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="subscriptionActionModalTitle"></h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                            </div>
                            <div class="modal-body" id="subscriptionActionModalBody"></div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                <button type="button" id="subscriptionActionModalConfirm" class="btn"></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
?>
