jQuery(document).ready(function($) {
    if (typeof Shepherd === 'undefined') {
        console.error('Shepherd is not loaded!');
        return;
    }

    const style = document.createElement('style');
    style.textContent = `
        .shepherd-modal-overlay-container,
        .shepherd-modal-overlay-container::before {
            position: fixed !important;
            top: 0 !important;
            left: 0 !important;
            width: 100% !important;
            height: 100% !important;
            background-color: rgba(0,0,0,0.5) !important;
            z-index: 9999 !important;
        }
        .shepherd-title {
            display: flex;
            gap: 8px;
        }
        
       .shepherd-button{
        background: #1a365d; 
       }
       .shepherd-button:not(:disabled):hover{
        background: #1a365d; 
       }
    `;
    document.head.appendChild(style);

    const tour = new Shepherd.Tour({
        defaultStepOptions: {
            cancelIcon: {
                enabled: true
            },
            scrollTo: {
                behavior: 'smooth',
                block: 'center'
            },
            classes: 'shepherd-theme-custom',
            modalOverlayOpeningPadding: 10,
            modalOverlayOpeningRadius: 8
        },
        useModalOverlay: true
    });

const isSubscriptionPage = window.location.href.includes('mind-web-subscriptions');
const isMindSpacesPage = window.location.href.includes('mind-web-spaces');
const isMindWebModelUsagePage = window.location.href.includes('mind-web-model-usage');
const isMindWebConversationsPage = window.location.href.includes('mind-web-chatbot-conversations');

// Settings page është VETËM nëse nuk është asnjë nga faqet e tjera
const isSettingsPage = window.location.href.includes('page=mind-web') && 
    !isSubscriptionPage && 
    !isMindSpacesPage && 
    !isMindWebModelUsagePage && 
    !isMindWebConversationsPage;

// Debug logging
console.log('Current URL:', window.location.href);
console.log('Is Conversations Page:', isMindWebConversationsPage);

if (isMindWebConversationsPage) {
    console.log('✅ Conversations page detected!');
    console.log('Filter element exists:', $('#filter-conversations').length > 0);
}

    if (isSettingsPage) {

        tour.addStep({
            id: 'welcome',
            title: '<i class="bi bi-hand-wave"></i> <strong>🎉 Welcome!</strong>',
            text:  ' Welcome to <strong>Mind Web </strong>! <br> We’ll guide you through the core features step by step, so you can get the most out of Mind Web right away 🚀',
            buttons: [{
                    text: 'Skip',
                    action: tour.cancel,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'chunk-size',
            title: '<i class="bi bi-arrows-expand"> </i><strong> Chunk Size</strong>',
            text: 'This setting controls how much text the system reads and processes at one time. Think of it as breaking a book into pages: each page has a certain number of characters. If the chunk size is too small, the assistant might miss some context. If it\'s too large, it might take longer to process. The default is 1000 characters, which works well for most content.',
            attachTo: {
                element: '#chatbot-chunk-size',
                on: 'bottom'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'chunk-overlap',
            title: '<i class="bi bi-layers"></i> <strong> Chunk Overlap</strong>',
            text: 'This determines how much each text piece overlaps with the previous one. Overlap helps make sure that no important information gets lost between chunks. For example, if one chunk ends mid-sentence, the next chunk will include some of the previous text to keep the meaning clear. Recommended: 200 characters.',
            attachTo: {
                element: '#chatbot-chunk-overlap',
                on: 'bottom'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'header-levels',
            title: '<i class="bi bi-type"></i> <strong> Header Levels</strong>',
            text: 'Here you choose which headings in your content the assistant should pay attention to—like titles and subheadings (H1, H2, H3, etc.). Headings help the system understand the structure and importance of different sections. For example, H1 is usually a main title, H2 a section title, and H3 a subsection.',
            attachTo: {
                element: '#chatbot-header-levels',
                on: 'bottom'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'ask-config',
            title: '<i class="bi bi-gear"></i> <strong> Ask Configuration</strong>',
            text: 'This setting decides how many top results the assistant considers when answering your questions. The assistant looks at your indexed content and selects the most relevant pieces. A higher number means more thorough answers, but it may take slightly longer. A smaller number gives quicker answers but might miss some details.',
            attachTo: {
                element: '#chatbot_ask_setting',
                on: 'bottom'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'save-settings',
            title: '<i class="bi bi-check-circle"></i> <strong> Save Your Changes</strong>',
            text: 'Click this button to save your settings. <br><strong>After saving, go to the Indexing tab to start indexing your content.</strong>',
            attachTo: {
                element: '.save-settings',
                on: 'top'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: function() {
                        $('[data-tab="indexing"]').click();
                        setTimeout(() => tour.next(), 300);
                    },
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'indexing-welcome',
            title: '<i class="bi bi-lightning-charge-fill"></i> <strong> Indexing Tab</strong>',
            text: 'Welcome to the Indexing section! Here you can tell the system to start reading and organizing your content, and keep track of how far it has gone.',
            buttons: [{
                    text: 'Skip',
                    action: tour.cancel,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'indexing-status',
            title: '<i class="bi bi-bar-chart-fill"></i> <strong> Indexing Status Dashboard</strong>',
            text: 'This dashboard shows your indexing statistics: Total Posts, Not Indexed items, Successfully Indexed items, and Progress percentage.',
            attachTo: {
                element: '.indexing-status',
                on: 'bottom'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'start-indexing',
            title: '<i class="bi bi-play-circle-fill"></i> <strong> Start Indexing</strong>',
            text: 'Click this button to begin indexing all your posts and pages. The progress bar will show real-time updates.<br><strong> After indexing, visit the Manage Items tab to view indexed content.</strong>',
            attachTo: {
                element: '#chatbot-index-all-items',
                on: 'bottom'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: function() {
                        // Click the OpenAI tab before showing next step
                        $('[data-tab="manage"]').click();
                        setTimeout(() => tour.next(), 300);
                    },
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'manage-welcome',
            title: '<i class="bi bi-list-check"></i> <strong> Manage Indexed Items</strong>',
            text: 'This section displays all your successfully indexed posts and pages. You can view details and remove items.',
            buttons: [{
                    text: 'Skip',
                    action: tour.cancel,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'indexed-table',
            title: '<i class="bi bi-table"></i> <strong> Indexed Items Table</strong>',
            text: 'This table shows all indexed items with details like Item ID, Post ID, Category, Author, Title, and Status.',
            attachTo: {
                element: '#table-indexed',
                on: 'top'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'unindex-all',
            title: '<i class="bi bi-trash-fill"></i> <strong> Unindex All Items</strong>',
            text: 'Use this button to remove all indexed items at once. This is useful if you want to start fresh. Use with caution!',
            attachTo: {
                element: '#chatbot-unindex-all-items',
                on: 'bottom'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'pagination',
            title: '<i class="bi bi-arrow-left-right"></i> <strong> Pagination Controls</strong>',
            text: 'Navigate through multiple pages of indexed items using these pagination controls. <br><strong>After this, you will move to the Technical Options tab to view your technical settings.</strong>',
            attachTo: {
                element: '#pagination-buttons',
                on: 'top'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: function() {
                        $('[data-tab="technical_options"]').click();
                        setTimeout(() => tour.next(), 300);
                    },
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'technical-welcome',
            title: '<i class="bi bi-gear"></i> <strong> Technical Options</strong>',
            text: 'This section displays advanced technical settings including your base URL, username, and credentials.You can only view these settings here, for security reasons you cannot change them directly.',
            buttons: [{
                    text: 'Skip',
                    action: tour.cancel,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'base-url',
            title: '<i class="bi bi-link-45deg"></i> <strong> Base URL</strong>',
            text: ' This is your platform\'s <strong>Base URL</strong> for API requests.  All communication with the RAG Smart Processes backend will go through this URL:<br><code>https://rag.smartprocesses.cloud</code><br><br>Make sure it is correct to ensure proper connectivity and data syncing.',
            attachTo: {
                element: '#chatbot-base-url',
                on: 'bottom'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'username',
            title: '<i class="bi bi-person-circle"></i> <strong> Username</strong>',
            text: 'Your registered username for the Mind Web system used to authenticate your indexing requests.',
            attachTo: {
                element: '#username',
                on: 'bottom'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'indexing-info',
            title: '<i class="bi bi-hash"></i> <strong> Indexing Information</strong>',
            text: 'This is the ID and name that the system uses to keep track of your indexed content. Think of it like a label for your documents — it helps the assistant know which content belongs to you.',
            attachTo: {
                element: '#chatbot-indexing-id',
                on: 'bottom'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'category',
            title: '<i class="bi bi-tags"></i>  <strong> Category Configuration</strong>',
            text: 'This shows the ID and name of your category. Think of it like a label that helps the assistant know where to find and organize your content.<br><br><strong>After this, you can go to the Subscriptions page to see your plan and trial status.</strong>',
            attachTo: {
                element: '.category-info',
                on: 'top'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Finish',
                    action: function() {
                        localStorage.setItem('mindweb_tour_technical_completed', 'true');
                        tour.complete();
                    },
                    classes: 'shepherd-button-primary'
                }
            ]
        });
    }

    if (isSubscriptionPage) {
        tour.addStep({
            id: 'sub-welcome',
            title: '<i class="bi bi-credit-card"></i> <strong> Welcome to Subscriptions!</strong>',
            text: 'Manage your Mind Web subscription, view your trial status, and access subscription history.',
            buttons: [{
                    text: 'Skip',
                    action: tour.cancel,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'plugin-guid',
            title: '<i class="bi bi-key"></i> <strong> Plugin GUID</strong>',
            text: 'Your unique plugin identifier. This GUID connects your WordPress site to Mind Web services.',
            attachTo: {
                element: '#chatbot-guid',
                on: 'bottom'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'site-url',
            title: '<i class="bi bi-globe"></i> <strong> Site URL</strong>',
            text: 'Your WordPress site address. This is the web address where your site lives. <br> <strong>Next, let\'s explore the Subscriptions Overview tab to see your current plan and trial status.</strong>',
            attachTo: {
                element: '#site-url',
                on: 'bottom'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: function() {
                        $('[data-tab="subscriptions"]').click();
                        setTimeout(() => tour.next(), 300);
                    },
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'sub-overview-welcome',
            title: '<i class="bi bi-credit-card-2-front"></i> <strong> Subscriptions Overview</strong>',
            text: 'Monitor your subscription and trial period, and manage your plan effortlessly.<br><br>⚠️ <strong>7-Day Trial Ending Soon!</strong><br>Your free trial expires in 7 days. After that, chat and premium features will be paused, but all your settings and data remain safe. Upgrade anytime to restore full access instantly.',
            buttons: [{
                    text: 'Skip',
                    action: tour.cancel,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: function() {
                        setTimeout(() => {
                            if ($('#buy_subscription').length && $('#buy_subscription').is(':visible')) {
                                tour.show('buy-subscription');
                            } else if ($('#refresh-plugin').length && $('#refresh-plugin').is(':visible')) {
                                tour.show('refresh-status');
                            } else {
                                tour.show('subscription-cards-container');
                            }
                        }, 100);
                    },
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'buy-subscription',
            title: '<i class="bi bi-cart-fill"></i> <strong> Buy Subscription</strong>',
            text: 'Click here to purchase a Mind Web subscription and unlock all premium features. After purchasing, click <i class="text-primary">Refresh Subscription Status</i> or refresh the page to see your active subscription.',
            attachTo: {
                element: '#buy_subscription',
                on: 'bottom'
            },
            when: {
                show: function() {
                    if (!$('#buy_subscription').is(':visible')) {
                        tour.show('subscription-cards-container');
                    }
                }
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: () => tour.show('subscription-cards-container'),
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'refresh-status',
            title: '<i class="bi bi-arrow-clockwise"></i> <strong> Refresh Subscription Status</strong>',
            text: 'Click here to refresh your subscription details or reload the page and make sure your current plan, trial status, and any changes are up to date. Use this after making a purchase or if you think your subscription status has changed. <br><br><strong> You can <i class="text-danger">cancel</i> or <i class="text-success">re-activate</i> your subscription using the buttons in the table below. Simply click the corresponding action next to your subscription entry to manage your plan instantly.</strong>',
            attachTo: {
                element: '#refresh-plugin',
                on: 'bottom'
            },
            when: {
                show: function() {
                    if (!$('#refresh-plugin').is(':visible')) {
                        tour.show('subscription-cards-container');
                    }
                }
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: () => tour.show('subscription-cards-container'),
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'subscription-cards-container',
            title: '<i class="bi bi-table"></i> <strong> Subscription Details</strong>',
            text: 'View all details of your current subscription: ID, creation date, billing period, type, status, and management options. <br> <strong>After this, you will check out the Subscription History tab to review your past subscription activities.</strong>',
            attachTo: {
                element: '#subscription-cards-container',
                on: 'top'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: function() {
                        $('[data-tab="logs"]').click();
                        setTimeout(() => tour.next(), 300);
                    },
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'sub-history-welcome',
            title: '<i class="bi bi-clock-history"></i> <strong> Subscriptions History</strong>',
            text: 'Review all past subscription events, updates, and important messages.',
            buttons: [{
                    text: 'Skip',
                    action: tour.cancel,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'logs-table',
            title: '<i class="bi bi-list-ul"></i> <strong> Activity Logs</strong>',
            text: 'Track your subscription history with detailed logs showing subscription IDs, dates, and event messages.<br><strong>Once you\'ve reviewed this, you can explore Mind Spaces page to access your spaces!</strong>',
            attachTo: {
                element: '#logs-cards-container',
                on: 'top'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Finish',
                    action: function() {
                        localStorage.setItem('mindweb_tour_sub_history_completed', 'true');
                        tour.complete();
                    },
                    classes: 'shepherd-button-primary'
                }
            ]
        });
    }

    if (isMindSpacesPage) {

        tour.addStep({
            id: 'mindspaces-welcome',
            title: '<i class="bi bi-lightning-fill"></i> <strong> Welcome to Mind Spaces!</strong>',
            text: 'Manage your Mind Spaces spaces and connect them to your WordPress pages for intelligent content assistance.',
            buttons: [{
                    text: 'Skip',
                    action: tour.cancel,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'mindspaces-base-url',
            title: '<i class="bi bi-link-45deg"></i> <strong> Base URL</strong>',
            text: 'The Mind Spaces server URL. This connects to your Mind Spaces account where your spaces are stored.',
            attachTo: {
                element: '#chatbot-base-url',
                on: 'bottom'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'mindspaces-username',
            title: '<i class="bi bi-person"></i> <strong> Username</strong>',
            text: 'Enter your Mind Spaces account email to access your spaces.',
            attachTo: {
                element: '#chatbot-username',
                on: 'bottom'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'mindspaces-password',
            title: '<i class="bi bi-lock"></i> <strong> Password</strong>',
            text: 'Enter your Mind Spaces password. Click the eye icon to show/hide your password and if you are not logged in , <strong>click the login button below.</strong>',
            attachTo: {
                element: '#chatbot-password',
                on: 'bottom'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: function() {
                        $('[data-tab="page_based_notebooks"]').click();
                        setTimeout(() => tour.next(), 300);
                    },
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'notebooks-welcome',
            title: '<i class="bi bi-lightbulb"></i> <strong> Mind Spaces</strong>',
            text: 'View and manage all your Mind Spaces spaces. Select one or more default space to answer visitor questions.',
            buttons: [{
                    text: 'Skip',
                    action: tour.cancel,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'page-notebooks-welcome',
            title: '<i class="bi bi-journal-text"></i> <strong> Page Based Spaces</strong>',
            text: 'Link specific spaces to individual WordPress pages for targeted knowledge assistance.',
            buttons: [{
                    text: 'Skip',
                    action: tour.cancel,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'add-page-notebook',
            title: '<i class="bi bi-plus-circle"></i> <strong> Add Knowledge Base</strong>',
            text: 'Click here to add a new page-based space. Select which pages should use which spaces for answering questions.',
            attachTo: {
                element: '#add-page-based-notebook',
                on: 'bottom'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'page-notebooks-table',
            title: '<i class="bi bi-table"></i> <strong> Page Spaces Table</strong>',
            text: 'This card lists all your Mind Spaces spaces, showing each space\'s name, ID, and reference number (Ref). You can select one or more spaces, and the assistant will use the selected spaces to answer your questions.',
            attachTo: {
                element: '.page-notebook-card',
                on: 'top'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'remove-all-page-notebooks',
            title: '<i class="bi bi-trash3"></i> <strong> Remove All</strong>',
            text: 'Remove all page-based space associations at once. Use with caution - this will clear all page-specific space links.',
            attachTo: {
                element: '#remove-all-page-notebooks',
                on: 'bottom'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'mindspaces-tour-complete',
            title: '<i class="bi bi-check-circle"></i> <strong class="text-success">All Set!</strong>',
            text: `
            🎉 Congratulations! You've completed the Mind Web tour.
            <br><br>
            Now you can explore the entire system freely: view your spaces, manage settings, check your subscription, and use the assistant to ask questions or get help.
            <br><br>
            <strong>Have fun discovering all the features!</strong>
            `,
            buttons: [{
                text: 'Close',
                action: tour.complete,
                classes: 'shepherd-button-primary'
            }]
        });
    }

    if (isMindWebModelUsagePage) {
        tour.addStep({
            id: 'welcome',
            title: '<i class="bi bi-emoji-smile"></i> Welcome to Mind Web Model Configuration',
            text: `
                <p>This quick tour will guide you through setting up your LLM (Large Language Model) configuration.</p>
                <p>You'll learn how to:</p>
                <ul>
                    <li>Navigate between tabs</li>
                    <li>Configure OpenAI settings</li>
                    <li>Save and manage your API credentials</li>
                </ul>
            `,
            buttons: [
                {
                    text: 'Skip',
                    action: tour.cancel,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });




        tour.addStep({
            id: 'build-model-tab',
            title: '<i class="bi bi-layout-text-sidebar-reverse"></i> Build a Model Overview',
            text: 'This tab shows which model provider you\'re currently using. Click the button to quickly navigate to the configuration page.',
            attachTo: {
                element: '#tab-build_model',
                on: 'top'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: function() {
                        $('[data-tab="openai_provider"]').click();
                        setTimeout(() => tour.next(), 300);
                    },
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'openai-tab',
            title: '<i class="bi bi-gear-fill"></i> OpenAI Configuration',
            text: 'This is the OpenAI configuration tab where you can set up your API credentials and model settings.',
            attachTo: {
                element: '[data-tab="openai_provider"]',
                on: 'bottom'
            },
            buttons: [{
                    text: 'Back',
                    action: function() {
                        $('[data-tab="build_model"]').click();
                        setTimeout(() => tour.back(), 300);
                    },
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'edit-button',
            title: '<i class="bi bi-pencil-square"></i> Edit Configuration',
            text: 'Click this button to enable editing of your LLM configuration. The form fields will become editable.',
            attachTo: {
                element: '.btn-update-llm',
                on: 'left'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'name-field',
            title: '<i class="bi bi-card-text"></i> Configuration Name',
            text: 'Give your LLM configuration a memorable name. ',
            attachTo: {
                element: '#api-llm-name',
                on: 'right'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'base-url-field',
            title: '<i class="bi bi-link-45deg"></i> API Base URL',
            text: 'Enter the API endpoint URL. ',
            attachTo: {
                element: '#api-base-url-llm',
                on: 'right'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'model-name-field',
            title: '<i class="bi bi-cpu-fill"></i> Model Identifier',
            text: 'Specify the exact model you want to use. For example: <code>gpt-4</code>, <code>gpt-4-turbo</code>, or <code>gpt-3.5-turbo</code>.',
            attachTo: {
                element: '#api-model-name',
                on: 'right'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'api-key-field',
            title: '<i class="bi bi-key-fill"></i> API Key',
            text: `
                <p>Enter your OpenAI API key here. Your key will be encrypted and stored securely.</p>
                <p><strong>Security tip:</strong> Never share your API key publicly!</p>
            `,
            attachTo: {
                element: '#api-key',
                on: 'right'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Next',
                    action: tour.next,
                    classes: 'shepherd-button-primary'
                }
            ]
        });

        tour.addStep({
            id: 'toggle-password',
            title: '<i class="bi bi-eye-fill"></i> Show/Hide API Key',
            text: 'Click the eye icon to toggle the visibility of your API key. This is useful for verifying that you’ve entered it correctly. <br> <b>Once you’ve filled in all the required fields, click the button below to save your configuration and <span class="text-success"> connect </span> to the LLM provider, or click <span class="text-danger"> disconnect </span> to remove the connection.</b>',
            attachTo: {
                element: '#toggle-api-key',
                on: 'left'
            },
            buttons: [{
                    text: 'Back',
                    action: tour.back,
                    classes: 'shepherd-button-secondary'
                },
                {
                    text: 'Finish Tour',
                    action: function() {
                        localStorage.setItem('mindweb_tour_model_usage_completed', 'true');
                        tour.complete();
                    },
                    classes: 'shepherd-button-primary'
                }
            ]
        });
    }

    if (isMindWebConversationsPage) {
    console.log('Loading Conversations tour steps...');
    
    tour.addStep({
        id: 'conversations-welcome',
        title: '<i class="bi bi-chat-dots"></i> <strong>Welcome to Conversations!</strong>',
        text: 'View and manage all chatbot conversations with your visitors. This page shows all the interactions between your chatbot and users.',
        buttons: [{
            text: 'Skip',
            action: tour.cancel,
            classes: 'shepherd-button-secondary'
        },
        {
            text: 'Next',
            action: tour.next,
            classes: 'shepherd-button-primary'
        }]
    });

    tour.addStep({
        id: 'conversations-table',
        title: '<i class="bi bi-table"></i> <strong>Conversations Card</strong>',
        text: 'This card displays all your chatbot conversations. You can view message history, timestamps, and user interactions.',
         attachTo: {
                element: '.conversation-card',
                on: 'right'
        },
        buttons: [{
            text: 'Back',
            action: tour.back,
            classes: 'shepherd-button-secondary'
        },
        {
            text: 'Next',
            action: tour.next,
            classes: 'shepherd-button-primary'
        }]
    });

    tour.addStep({
        id: 'conversations-complete',
        title: '<i class="bi bi-check-circle"></i> <strong>Tour Complete!</strong>',
        text: 'You\'re all set! You can now manage and review all your chatbot conversations.',
        buttons: [{
            text: 'Finish',
            action: function() {
                localStorage.setItem('mindweb_tour_conversations_completed', 'true');
                tour.complete();
            },
            classes: 'shepherd-button-primary'
        }]
    });
}

    window.tour = tour;

 function startTourForCurrentTab() {
    if (tour && tour.isActive()) {
        tour.cancel();
    }

    let startStep = null;

    if (isSettingsPage) {
        const currentTab = $('.nav-tab-active').data('tab') || 'settings';
        const tabSteps = {
            'settings': 'welcome',
            'indexing': 'indexing-welcome',
            'manage': 'manage-welcome',
            'technical_options': 'technical-welcome'
        };
        startStep = tabSteps[currentTab];
    } else if (isSubscriptionPage) {
        const currentTab = $('.nav-tab-active').data('tab') || 'settings';
        const tabSteps = {
            'settings': 'sub-welcome',
            'subscriptions': 'sub-overview-welcome',
            'logs': 'sub-history-welcome'
        };
        startStep = tabSteps[currentTab];
    } else if (isMindSpacesPage) {
        const currentTab = $('.nav-tab-active').data('tab') || 'general';
        const tabSteps = {
            'general': 'mindspaces-welcome',
            'notebooks': 'notebooks-welcome',
            'page_based_notebooks': 'page-notebooks-welcome'
        };
        startStep = tabSteps[currentTab];
    } else if (isMindWebModelUsagePage) {
        const currentTab = $('.nav-tab-active').data('tab') || 'build_model';
        const tabSteps = {
            'build_model': 'welcome',
            'openai_provider': 'openai-tab'
        };
        startStep = tabSteps[currentTab];
    } else if (isMindWebConversationsPage) {
        // Conversations page nuk ka tabs, fillon direkt me welcome
        startStep = 'conversations-welcome';
    }

    if (startStep) {
        setTimeout(() => {
            tour.start();
            tour.show(startStep);
        }, 300);
    }
}

    let completedKey = 'mindweb_tour_general_completed';
if (isSettingsPage) {
    completedKey = 'mindweb_tour_general_completed';
} else if (isSubscriptionPage) {
    completedKey = 'mindweb_tour_sub_config_completed';
} else if (isMindSpacesPage) {
    completedKey = 'mindweb_tour_mindspaces_general_completed';
} else if (isMindWebModelUsagePage) {
    completedKey = 'mindweb_tour_model_usage_completed';
} else if (isMindWebConversationsPage) {
    completedKey = 'mindweb_tour_conversations_completed';
}

    $('#start-tour-btn').on('click', function() {
        startTourForCurrentTab();
    });

    $(document).on('click', '.shepherd-cancel-icon', function() {
        $('#start-tour-btn').prop('disabled', false);
    });

    window.tour.on('complete', function() {
        $('#start-tour-btn').prop('disabled', false);
    });

    window.addBuyAndRefreshSteps = function() {
        if ($('#buy_subscription').is(':visible') && !tour.getById('buy_subscription')) {
            tour.addStep({
                id: 'buy_subscription',
                title: '<i class="bi bi-cart-fill"></i> <strong class="text-success"> Buy Subscription</strong>',
                text: 'Click here to purchase a Mind Web subscription and unlock all premium features.',
                attachTo: {
                    element: '#buy_subscription',
                    on: 'bottom'
                },
                buttons: [{
                        text: 'Back',
                        action: tour.back,
                        classes: 'shepherd-button-secondary'
                    },
                    {
                        text: 'Next',
                        action: tour.next,
                        classes: 'shepherd-button-primary'
                    }
                ]
            });
        }

        if ($('#refresh-plugin').is(':visible') && !tour.getById('refresh_plugin')) {
            tour.addStep({
                id: 'refresh_plugin',
                title: '<i class="bi bi-arrow-clockwise"></i> <strong> Refresh Status</strong>',
                text: 'Click here to refresh your subscription details and make sure your current plan, trial status, and any changes are up to date.',
                attachTo: {
                    element: '#refresh-plugin',
                    on: 'bottom'
                },
                buttons: [{
                        text: 'Back',
                        action: tour.back,
                        classes: 'shepherd-button-secondary'
                    },
                    {
                        text: 'Next',
                        action: tour.next,
                        classes: 'shepherd-button-primary'
                    }
                ]
            });
        }
    };
});