jQuery(document).ready(function($) {
    const $form = $('#llm-config-form');
    const $connectBtn = $('#chatbot-connect-api');
    const $formInputs = jQuery('#llm-config-form .form-input');
    const toggleApiBtn = document.getElementById('toggle-api-key');
    const $disconnectBtn = $('#chatbot-llm-disconnect-api');
    if ($form.length === 0) {
        console.error('ERROR: #llm-config-form NOT FOUND in DOM.');
        return;
    }

    function setProviderFromActiveTab() {
        const $activeTab = $('.chatbot-nav-tab.nav-tab-active');
        const provider = $activeTab.data('provider');
        if (provider) $('#api-provider').val(provider);
    }

    $(document).on('click', '.chatbot-nav-tab', function(e) {
        e.preventDefault();
        $('.chatbot-nav-tab').removeClass('nav-tab-active');
        $(this).addClass('nav-tab-active');

        const tab = $(this).data('tab');
        $('.tab-content').hide();
        $('#tab-' + tab).show();

        setProviderFromActiveTab();
    });

    $(document).on('click', '.go-to-tab-btn', function(e) {
        e.preventDefault();
        const tab = $(this).data('tab');

        $('.chatbot-nav-tab').removeClass('nav-tab-active');
        $('.chatbot-nav-tab[data-tab="' + tab + '"]').addClass('nav-tab-active');

        $('.tab-content').hide();
        $('#tab-' + tab).show();

        setProviderFromActiveTab();
    });

    setProviderFromActiveTab();

    const isConnected = chatbotLLMConfig.llm_config_id;
    if (isConnected) {
        $formInputs.prop('disabled', true);
        $connectBtn.hide();
        $disconnectBtn.removeClass('d-none').show();
    }

    $form.on('submit', function(e) {
        e.preventDefault();
        if ($connectBtn.prop('disabled')) return;

        const originalBtnText = $connectBtn.html();
        $connectBtn.prop('disabled', true).html('<i class="bi bi-hourglass-split"></i> Connecting...');

        const formData = {
            action: 'chatbot_create_attach_llm_confing_to_indexing',
            nonce: chatbotLLMConfig.nonce,
            name: $('#api-llm-name').val(),
            llm_base_url: $('#api-base-url-llm').val(),
            model_name: $('#api-model-name').val(),
            provider: $('#api-provider').val(),
            api_key: $('#api-key').val()
        };

        const emptyFields = [];
        for (const key in formData) {
            if (!formData[key]) emptyFields.push(key);
        }

        if (emptyFields.length) {
            console.error('[LLM-DEBUG] Validation failed:', emptyFields);
            ChatbotToast.error( 'Required fields missing: ' + emptyFields.join(', '));
            $connectBtn.prop('disabled', false).html(originalBtnText);
            return;
        }

        $.ajax({
            url: chatbotLLMConfig.ajax_url,
            type: 'POST',
            data: formData,
            success: function(response, textStatus, xhr) {

                if (response.success) {
                     ChatbotToast.success(response.data.message || 'LLM Configuration saved successfully!');
                    $connectBtn.hide();
                    $formInputs.prop('disabled', true);
                    $disconnectBtn.removeClass('d-none').show();
                } else {
                    console.error('[LLM-DEBUG] Server returned error:', response.data?.message);
                     ChatbotToast.error( response.data?.message || 'Failed to save LLM configuration');
                    $connectBtn.prop('disabled', false).html(originalBtnText);
                }
            },
            error: function(xhr, status, error) {
                console.error('[LLM-DEBUG] AJAX ERROR:', xhr.status, error);
                 ChatbotToast.error( 'An error occurred: ' + error + ' (HTTP ' + xhr.status + ')');
                $connectBtn.prop('disabled', false).html(originalBtnText);
            }
        });
    });

    $(document).on('click', '.btn-update-llm', function() {
        $('.btn-save-changes').removeClass('d-none');
        $('.btn-update-llm').hide();

        $('#llm-config-form')
            .find('input, select, textarea')
            .prop('disabled', false);
        $('#llm-config-form')
            .find('input, select, textarea').addClass('update-input-on-edit');
    });



    $(document).on('click', '#llm-save-changes', function(e) {
        e.preventDefault();

        const $btn = $(this);
        $btn.prop('disabled', true).text('Saving...');

        const data = {
            action: 'chatbot_update_llm_config',
            nonce: chatbotModelUsage.nonce,
            name: $('#api-llm-name').val(),
            llm_base_url: $('#api-base-url-llm').val(),
            model_name: $('#api-model-name').val(),
            provider: $('#api-provider').val(),
            api_key: $('#api-key').val()
        };

        $.post(chatbotModelUsage.ajax_url, data)
            .done(function(response) {

                if (!response || typeof response !== 'object') {
                    console.error('Invalid response:', response);
                    alert('Unexpected server response');
                    return;
                }

                const message = response?.data?.message || 'LLM updated successfully!';

                if (response.success) {

                     ChatbotToast.success(message);

                    $('#llm-config-form')
                        .find('input, select, textarea')
                        .prop('disabled', true);

                    $('.btn-save-changes').addClass('d-none');
                    $('.btn-update-llm').show();

                } else {
                     ChatbotToast.error( message);
                    $btn.prop('disabled', false).text('Save Changes');
                }
            })
            .fail(function(xhr) {
                console.error('AJAX Error:', xhr.responseText);
                ChatbotToast.error( 'AJAX request failed');
                $btn.prop('disabled', false).text('Save Changes');
            })
            .always(function() {
                $btn.prop('disabled', false).text('Save Changes');
                $('#llm-config-form')
                    .find('input, select, textarea')
                    .prop('disabled', true)
                    .removeClass('update-input-on-edit');

            });
    });

    $(document).on('click', '#chatbot-llm-disconnect-api', function(e) {
        e.preventDefault();

        $('#disconnectLlmModalTitile').text('Confirm Disconnect');
        $('#disconnectLlmModalBody').text('Are you sure you want to disconnect this configuration?');

        $('#disconnectLlmModalConfirm')
            .addClass('btn-danger')
            .html(`
            <svg width="18" height="18" viewBox="0 0 24 24" fill="currentColor">
                <path d="M7 2v6H5v4c0 1.5.5 2.9 1.3 4L3 19l2 2 3.2-3.2A7 7 0 0019 12V8h-2V2h-2v6H9V2H7zm0 10V10h10v2a5 5 0 01-8.9 3.1l1.4-1.4A3 3 0 0017 12v-2H7z"/>
            </svg>
            Disconnect LLM
        `);

        $('#disconnectLlmModalConfirm')
            .off('click')
            .on('click', function() {

                $('#disconnectLlm').modal('hide');

                const $btn = $(this);
                const originalText = $btn.html();

                $btn.prop('disabled', true)
                    .html('<i class="bi bi-hourglass-split"></i> Disconnecting...');

                $.post(chatbotLLMConfig.ajax_url, {
                        action: 'chatbot_delete_llm_config_ajax',
                        nonce: chatbotLLMConfig.nonce
                    })
                    .done(function(response) {
                        if (response.success) {
                             ChatbotToast.success( response.data.message);
                            setTimeout(() => location.reload(), 1000);
                        } else {
                             ChatbotToast.error(response.data.message);
                            $btn.prop('disabled', false).html(originalText);
                        }
                    });
            });
        $('#disconnectLlm').modal('show');
    });


    if (chatbotModelUsage.llm_config_id) {
        $('#llm-config-form').find('input, select, textarea').prop('disabled', true);
        $('.btn-save-changes').addClass('d-none');
        $('.btn-update-llm').show();
    }

});