/**
 * @version 1.0.0
 */

(function () {
    if (window.ChatbotToast) return;

    class ChatbotToastComponent {
        constructor(options = {}) {
            this.options = {
                duration: 3000,
                position: 'top-0 end-0',
                ...options
            };

            this.container = this.getOrCreateContainer();
        }

        getOrCreateContainer() {
            let container = document.getElementById('chatbot-toast-container');

            if (!container) {
                container = document.createElement('div');
                container.id = 'chatbot-toast-container';
                container.className = `toast-container position-fixed ${this.options.position} p-3`;
                container.style.zIndex = '9999';
                document.body.appendChild(container);
            }

            return container;
        }

        createToast(message, type, icon = '') {
            const toast = document.createElement('div');
            toast.className = `toast align-items-center text-bg-${type} border-0`;
            toast.setAttribute('role', 'alert');

            toast.innerHTML = `
                <div class="d-flex">
                    <div class="toast-body">${icon}${message}</div>
                    <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
                </div>
            `;

            return toast;
        }

        show(message, type = 'primary', icon = '') {
            const toastEl = this.createToast(message, type, icon);
            this.container.appendChild(toastEl);

            const bsToast = new bootstrap.Toast(toastEl, {
                autohide: true,
                delay: this.options.duration
            });

            bsToast.show();

            toastEl.addEventListener('hidden.bs.toast', () => toastEl.remove());
        }

        success(msg) { return this.show(msg, 'success'); }
        error(msg) { return this.show(msg, 'danger'); }
        warning(msg) { return this.show(msg, 'warning'); }
        info(msg) { return this.show(msg, 'info'); }
    }

    window.ChatbotToast = new ChatbotToastComponent();
})();
