jQuery(document).ready(function($) {

    window.ChatbotPagination.options.itemsPerPage = 2; 
    window.ChatbotPagination.options.scrollOffset = 150; 

    $('.datepicker').datepicker({
        dateFormat: 'yy-mm-dd',
        changeMonth: true,
        changeYear: true,
        maxDate: 0,
        showAnim: 'fadeIn',
        showButtonPanel: true,
        beforeShow: function(input, inst) {
            setTimeout(function() {
                inst.dpDiv.css({
                    marginTop: '5px'
                });
            }, 0);
        }
    });

    $('#start-date').on('change', function() {
        var startDate = $(this).datepicker('getDate');
        $('#end-date').datepicker('option', 'minDate', startDate);
        $(this).addClass('has-value');
    });

    $('#end-date').on('change', function() {
        var endDate = $(this).datepicker('getDate');
        $('#start-date').datepicker('option', 'maxDate', endDate);
        $(this).addClass('has-value');
    });


    $('#filter-conversations').on('click', function() {
        var startDate = $('#start-date').val();
        var endDate = $('#end-date').val();

        if (!startDate || !endDate) {
            ChatbotToast.error('Please select both start and end dates');
            return;
        }

        $('#loading-spinner').addClass('active').show();

        $.ajax({
            url: chatbotDataKnowledgeRepository.ajax_url,
            type: 'POST',
            data: {
                action: 'chatbot_get_conversations_by_date',
                nonce: chatbotDataKnowledgeRepository.nonce,
                start_date: startDate,
                end_date: endDate
            },
            success: function(response) {
                $('#loading-spinner').removeClass('active').hide();

                if (response.success) {
                    window.ChatbotPagination.filter(
                        'conversations-container',
                        response.data.conversations
                    );

                    if (response.data.conversations.length > 0) {
                        ChatbotToast.success('Conversations loaded successfully');
                    } else {
                        ChatbotToast.warning('No conversations available for this date');
                    }
                }
            },
            error: function() {
                $('#loading-spinner').removeClass('active').hide();
                ChatbotToast.error('Failed to load conversations');
            }
        });
    });

    $('#clear-filter').on('click', function() {
        $('#start-date, #end-date').val('').removeClass('has-value');

        window.ChatbotPagination.clearFilter('conversations-container');

        loadTodayConversations();
        ChatbotToast.info('Filters cleared');
    });

    loadTodayConversations();

    $('.load-convs').on('click', function() {
        loadTodayConversations();
        $('#start-date, #end-date').val('').removeClass('has-value');
        $('#start-date, #end-date').datepicker('option', {
            minDate: null,
            maxDate: 0
        });
    })

    $('#close-modal').on('click', function() {
        $('#session-modal').fadeOut(300);
    });

    $('#close-conversation-modal').on('click', function() {
        $('#conversation-modal').fadeOut(300);
    });

    $(document).on('click', '#session-modal, #conversation-modal', function(e) {
        if (e.target.id === 'session-modal' || e.target.id === 'conversation-modal') {
            $(this).fadeOut(300);
        }
    });

    $(document).on('keyup', function(e) {
        if (e.key === 'Escape') {
            $('.modal-overlay').fadeOut(300);
        }
    });


    function displayConversationsGrid(conversations, total) {
        if (conversations.length === 0) {
            $('#conversations-results').html(
                '<div class="empty-state">' +
                '<svg width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="#d1d5db" stroke-width="1.5">' +
                '<path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>' +
                '</svg>' +
                '<h3>No Conversations Found</h3>' +
                '<p>No conversations found for this date range</p>' +
                '</div>'
            );
            return;
        }
        $('#conversations-results').html(`
        <div class="results-header">
            <h3>Conversations <span class="results-count">${total}</span></h3>
        </div>
        <div id="conversations-container" class="conversations-grid"></div>
    `);

        function renderConversationCard(conv, $container) {
            var questionCount = conv.total_questions || 0;
            var time = new Date(conv.created_at).toLocaleString('en-US', {
                year: 'numeric',
                month: 'short',
                day: '2-digit',
                hour: '2-digit',
                minute: '2-digit'
            });

            var avatarLetter = (conv.cookie_id || 'U').charAt(0).toUpperCase();
            var sessionId = (conv.cookie_id || 'Unknown').substring(0, 18);

            var html = '<div class="conversation-card">';
            html += '  <div class="card-header">';
            html += '    <div class="card-header-session">';
            html += '      <div class="card-avatar">' + avatarLetter + '</div>';
            html += '      <div class="card-info">';
            html += '        <div class="card-session-id" title="' + (conv.cookie_id || 'Unknown Session') + '">';
            html += '          <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">';
            html += '            <path d="M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>';
            html += '            <circle cx="8.5" cy="7" r="4"></circle>';
            html += '            <polyline points="17 11 19 13 23 9"></polyline>';
            html += '          </svg>';
            html += '          ' + sessionId + '...';
            html += '        </div>';
            html += '        <div class="card-time">' + time + '</div>';
            html += '      </div>';
            html += '    </div>';
            html += '    <button class="btn-delete-conversation" data-id="' + conv.id + '" title="Delete Conversation">';
            html += '      <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">';
            html += '        <polyline points="3 6 5 6 21 6"></polyline>';
            html += '        <path d="M19 6l-1 14a2 2 0 0 1-2 2H8a2 2 0 0 1-2-2L5 6"></path>';
            html += '        <path d="M10 11v6"></path>';
            html += '        <path d="M14 11v6"></path>';
            html += '      </svg>';
            html += '    </button>';
            html += '  </div>';

            html += '  <div class="card-meta">';
            html += '    <div class="card-meta-item">';
            html += '      <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">';
            html += '        <circle cx="12" cy="12" r="2"></circle>';
            html += '        <path d="M12 1v6m0 6v6m5.7-13.7l-4.2 4.2m0 6l4.2 4.2M23 12h-6m-6 0H1m19.7-5.7l-4.2 4.2m0 6l4.2 4.2"></path>';
            html += '      </svg>';
            html += '      <span class="card-meta-value">' + (conv.ip_address || '::1') + '</span>';
            html += '    </div>';
            html += '    <div class="card-meta-item">';
            html += '      <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">';
            html += '        <rect x="2" y="3" width="20" height="14" rx="2" ry="2"></rect>';
            html += '        <line x1="8" y1="21" x2="16" y2="21"></line>';
            html += '        <line x1="12" y1="17" x2="12" y2="21"></line>';
            html += '      </svg>';
            html += '      <span class="card-meta-value">' + (conv.platform || 'Win32') + '</span>';
            html += '    </div>';
            html += '  </div>';

            html += '  <div class="card-footer">';
            html += '    <div class="card-questions">';
            html += '      <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">';
            html += '        <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>';
            html += '      </svg>';
            html += '      ' + questionCount + ' question';
            html += '    </div>';
            html += '    <div class="actions">';
            html += '      <a href="javascript:void(0)" class="card-action btn-view-conversation" data-id="' + conv.id + '">';
            html += '        See Chat';
            html += '        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">';
            html += '          <polyline points="9 18 15 12 9 6"></polyline>';
            html += '        </svg>';
            html += '      </a>';
            html += '      <a href="javascript:void(0)" class="card-action btn-view-details" data-conv=\'' + JSON.stringify(conv) + '\'>';
            html += '        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">';
            html += '          <path d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>';
            html += '          <path d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>';
            html += '        </svg>';
            html += '        Conversation Info';
            html += '      </a>';
            html += '    </div>';
            html += '  </div>';
            html += '</div>';

            $container.append(html);
        }

        window.ChatbotPagination.init(
            'conversations-container',
            conversations,
            renderConversationCard,
            1 
        );
    }

    $(document).on('click', '.btn-view-conversation', function(e) {
        e.stopPropagation();
        var convId = $(this).data('id');
        loadConversationQA(convId);
    });


    $(document).on('click', '.btn-view-details', function(e) {
        e.stopPropagation();
        var conv = JSON.parse($(this).attr('data-conv'));
        showSessionDetails(conv);
    });


    $(document).on('click', '.btn-delete-conversation', function(e) {
        e.stopPropagation();

        var convId = $(this).data('id');
        var $btn = $(this);

        ChatbotModal.confirm(
            'Delete Conversation',
            'Are you sure you want to delete this conversation? This action cannot be undone.',
            function() {
                deleteConversation(convId, $btn);
            },
            'Delete',
            'btn-danger'
        );
    });


    function deleteConversation(convId, $btn) {

        var originalHtml = $btn.html();
        $btn.prop('disabled', true)
            .html('<span class="dashicons dashicons-update spin"></span> Deleting...');

        $.ajax({
            url: chatbotDataKnowledgeRepository.ajax_url,
            type: 'POST',
            data: {
                action: 'chatbot_delete_conversation',
                nonce: chatbotDataKnowledgeRepository.nonce,
                conversation_id: convId
            },
            success: function(response) {

                if (response.success) {
                    $btn.closest('.conversation-card').fadeOut(300, function() {
                        $(this).remove();
                    });

                    ChatbotToast.success('Conversation deleted successfully');
                } else {
                    ChatbotToast.error(response.data || 'Failed to delete conversation');
                    $btn.prop('disabled', false).html(originalHtml);
                }
            },
            error: function() {
                ChatbotToast.error('Failed to delete conversation. Please try again.');
                $btn.prop('disabled', false).html(originalHtml);
            }
        });
    }


    function showSessionDetails(conv) {
        var html = '';

        html += '<div class="info-section">';
        html += '  <div class="info-section-header">';
        html += '    <div class="info-section-icon">';
        html += '      <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">';
        html += '        <rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect>';
        html += '        <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>';
        html += '      </svg>';
        html += '    </div>';
        html += '    <h3>Session Information</h3>';
        html += '  </div>';
        html += '  <div class="session-info-grid">';
        html += '    <div class="info-item">';
        html += '      <div class="info-label">Session ID</div>';
        html += '      <div class="info-value">' + (conv.cookie_id || 'N/A') + '</div>';
        html += '    </div>';
        html += '    <div class="info-item">';
        html += '      <div class="info-label">IP Address</div>';
        html += '      <div class="info-value">' + (conv.ip_address || 'N/A') + '</div>';
        html += '    </div>';
        html += '    <div class="info-item">';
        html += '      <div class="info-label">Screen Resolution</div>';
        html += '      <div class="info-value">' + (conv.screen_resolution || 'N/A') + '</div>';
        html += '    </div>';
        html += '    <div class="info-item">';
        html += '      <div class="info-label">Platform</div>';
        html += '      <div class="info-value">' + (conv.platform || 'N/A') + '</div>';
        html += '    </div>';
        html += '    <div class="info-item">';
        html += '      <div class="info-label">Timezone</div>';
        html += '      <div class="info-value">' + (conv.timezone || 'N/A') + '</div>';
        html += '    </div>';
        html += '    <div class="info-item">';
        html += '      <div class="info-label">Language</div>';
        html += '      <div class="info-value">' + (conv.language_accepted || 'N/A') + '</div>';
        html += '    </div>';
        html += '  </div>';
        html += '</div>';

        html += '<div class="info-section">';
        html += '  <div class="info-section-header">';
        html += '    <div class="info-section-icon">';
        html += '      <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">';
        html += '        <rect x="2" y="3" width="20" height="14" rx="2" ry="2"></rect>';
        html += '        <line x1="8" y1="21" x2="16" y2="21"></line>';
        html += '        <line x1="12" y1="17" x2="12" y2="21"></line>';
        html += '      </svg>';
        html += '    </div>';
        html += '    <h3>Browser & Device</h3>';
        html += '  </div>';
        html += '  <div class="info-item">';
        html += '    <div class="info-label">User Agent</div>';
        html += '    <div class="info-value" style="word-break: break-all;">' + (conv.user_agent || 'N/A') + '</div>';
        html += '  </div>';
        html += '</div>';

        html += '<div class="info-section">';
        html += '  <div class="info-section-header">';
        html += '    <div class="info-section-icon">';
        html += '      <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">';
        html += '        <polyline points="9 18 15 12 9 6"></polyline>';
        html += '      </svg>';
        html += '    </div>';
        html += '    <h3>Navigation Details</h3>';
        html += '  </div>';
        html += '  <div class="session-info-grid">';
        html += '    <div class="info-item">';
        html += '      <div class="info-label">Referrer</div>';
        html += '      <div class="info-value" style="word-break: break-all;">' + (conv.referrer || 'N/A') + '</div>';
        html += '    </div>';
        html += '  </div>';
        html += '</div>';

        html += '<div class="info-section">';
        html += '  <div class="info-section-header">';
        html += '    <div class="info-section-icon">';
        html += '      <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">';
        html += '        <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>';
        html += '      </svg>';
        html += '    </div>';
        html += '    <h3>Conversation Statistics</h3>';
        html += '  </div>';
        html += '  <div class="session-info-grid">';
        html += '    <div class="info-item">';
        html += '      <div class="info-label">Total Questions</div>';
        html += '      <div class="info-value" style="font-size: 24px; color: #667eea;">' + (conv.total_questions || 0) + '</div>';
        html += '    </div>';
        html += '    <div class="info-item">';
        html += '      <div class="info-label">First Question At</div>';
        html += '      <div class="info-value">' + (conv.first_question_at ? new Date(conv.first_question_at).toLocaleString() : 'N/A') + '</div>';
        html += '    </div>';
        html += '    <div class="info-item">';
        html += '      <div class="info-label">Conversation Created</div>';
        html += '      <div class="info-value">' + (conv.created_at ? new Date(conv.created_at).toLocaleString() : 'N/A') + '</div>';
        html += '    </div>';
        html += '  </div>';
        html += '</div>';

        $('#modal-content').html(html);
        $('#session-modal .modal-title').html('Session #' + conv.id + ' - Complete Details');
        $('#session-modal').fadeIn(300);
    }

    function loadConversationQA(convId) {
        $('#conversation-modal-content').html(
            '<div class="loading-state  d-flex align-items-center justify-content-center">' +
            '<div class="spinner is-active"></div>' +
            '<p>Loading conversation...</p>' +
            '</div>'
        );
        $('#conversation-modal').fadeIn(300);

        $.ajax({
            url: chatbotDataKnowledgeRepository.ajax_url,
            type: 'POST',
            data: {
                action: 'chatbot_get_conversations',
                nonce: chatbotDataKnowledgeRepository.nonce,
                conversation_id: convId
            },
            success: function(response) {
                if (response.success && response.data.length > 0) {
                    displayConversationQA(response.data, convId);
                } else {
                    $('#conversation-modal-content').html(
                        '<div class="error-state">' +
                        '<svg width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="#dc2626" stroke-width="1.5">' +
                        '<circle cx="12" cy="12" r="10"></circle>' +
                        '<line x1="15" y1="9" x2="9" y2="15"></line>' +
                        '<line x1="9" y1="9" x2="15" y2="15"></line>' +
                        '</svg>' +
                        '<h3>No Questions Found</h3>' +
                        '<p>No questions found for this conversation</p>' +
                        '</div>'
                    );
                }
            },
            error: function() {
                $('#conversation-modal-content').html(
                    '<div class="error-state">' +
                    '<svg width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="#dc2626" stroke-width="1.5">' +
                    '<circle cx="12" cy="12" r="10"></circle>' +
                    '<line x1="15" y1="9" x2="9" y2="15"></line>' +
                    '<line x1="9" y1="9" x2="15" y2="15"></line>' +
                    '</svg>' +
                    '<h3>Error Loading Conversation</h3>' +
                    '<p>Failed to load conversation. Please try again.</p>' +
                    '</div>'
                );
            }
        });
    }

    function loadTodayConversations() {
        $('#loading-spinner').addClass('active').show();
        $('#conversations-results').html('<div class="loading-state d-flex align-items-center justify-content-center"><div class="spinner is-active"></div><p>Loading today\'s conversations...</p></div>');

        $.ajax({
            url: chatbotDataKnowledgeRepository.ajax_url,
            type: 'POST',
            data: {
                action: 'chatbot_get_today_conversations',
                nonce: chatbotDataKnowledgeRepository.nonce
            },
            success: function(response) {
                $('#loading-spinner').removeClass('active').hide();

                if (response.success && response.data.conversations.length > 0) {
                    displayConversationsGrid(response.data.conversations, response.data.total);
                } else {
                    $('#conversations-results').html(
                        '<div class="empty-state">' +
                        '<h3>No conversations today</h3>' +
                        '<p>There are no conversations for today.</p>' +
                        '</div>'
                    );
                }
            },
            error: function() {
                $('#loading-spinner').removeClass('active').hide();
                $('#conversations-results').html(
                    '<div class="error-state">' +
                    '<h3>Error Loading Today\'s Conversations</h3>' +
                    '</div>'
                );
            }
        });
    }


    function displayConversationQA(questions, convId) {
        var html = '<div class="qa-list">';

        questions.forEach(function(qa, index) {
            var askedTime = qa.created_at ? new Date(qa.created_at).toLocaleString('en-US', {
                month: 'short',
                day: 'numeric',
                year: 'numeric',
                hour: '2-digit',
                minute: '2-digit'
            }) : 'N/A';

            var answeredTime = qa.response_at ? new Date(qa.response_at).toLocaleString('en-US', {
                month: 'short',
                day: 'numeric',
                year: 'numeric',
                hour: '2-digit',
                minute: '2-digit'
            }) : null;

            html += '<div class="qa-card">';

            html += '  <div class="qa-question-block">';
            html += '    <div class="qa-icon">Q</div>';
            html += '    <div class="qa-question-text">' + (qa.question_text || 'N/A') + '</div>';
            html += '  </div>';

            html += '  <div class="qa-answer-block">';
            html += '    <div class="qa-answer-icon">A</div>';
            html += '    <div class="qa-answer-text">' + (qa.response_text || 'No response') + '</div>';
            html += '  </div>';

            html += '  <div class="qa-timestamp">';
            html += '    <span>';
            html += '      <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">';
            html += '        <circle cx="12" cy="12" r="10"></circle>';
            html += '        <polyline points="12 6 12 12 16 14"></polyline>';
            html += '      </svg>';
            html += '      Asked: ' + askedTime;
            html += '    </span>';
            if (answeredTime) {
                html += '    <span>';
                html += '      <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">';
                html += '        <polyline points="20 6 9 17 4 12"></polyline>';
                html += '      </svg>';
                html += '      Answered: ' + answeredTime;
                html += '    </span>';
            }
            html += '  </div>';

            html += '</div>';
        });

        html += '</div>';

        $('#conversation-modal-content').html(html);
        $('#conversation-modal .modal-title').html('Conversation #' + convId + ' - Q&A History (' + questions.length + ' questions)');
    }
});