jQuery(document).ready(function($) {

    let rowsPerPage = 7; 
    let currentPage = 1;

    function updateCounters() {
        $.post(chatbotPlugin.ajax_url, {
                action: 'chatbot_get_stats',
                nonce: chatbotPlugin.nonce
            })
            .done(function(response) {
                if (response.success) {
                    var stats = response.data;

                    $('#to-index-count').text(stats.to_index);
                    $('#indexed-count').text(stats.indexed);
                    $('#index-progress').text(stats.progress + '%');
                }
            })
            .fail(function(xhr, status, error) {
                console.error('COUNTER Failed:', error);
            });
    }

    $('.nav-tab').on('click', function(e) {
        e.preventDefault();
        $('.nav-tab').removeClass('nav-tab-active');
        $(this).addClass('nav-tab-active');

        var tab = $(this).data('tab');
        $('.tab-content').hide();
        $('#tab-' + tab).show();

        if (tab === 'manage') {
            loadIndexedTable();
        }
    });

    function createPagination(pages, page) {
    currentPage = page;
    let str = `<div class="d-flex align-items-center justify-content-center mt-3" style="gap: 5px">`;
    let active;

    if (page > 1) {
        str += `<button class="btn page-item previous" onclick="return false;" data-page="${page - 1}" style="background: #1a365d; color: #fff;">Previous</button>`;
    }

    let start = 1;
    let end = pages;

    if (pages > 20) {
        start = Math.max(page - 2, 1);
        end = Math.min(page + 2, pages);
        if (start > 1) {
            str += `<button class="btn page-item" onclick="return false;" data-page="1" style="background: #1a365d; color: #fff;">1</button>`;
            if (start > 2) {
                str += `<span style="padding:0 5px;">...</span>`;
            }
        }
    }

    for (let p = start; p <= end; p++) {
        active = page == p ? "active" : "";
        str += `<button class="btn page-item ${active}" onclick="return false;" data-page="${p}" style="background: ${active ? '#ff9800' : '#1a365d'}; color: ${active ? '#000' : '#fff'};">${p}</button>`;
    }

    if (pages > 20 && end < pages) {
        if (end < pages - 1) {
            str += `<span style="padding:0 5px;">...</span>`;
        }

        str += `<button class="btn page-item" onclick="return false;" data-page="${pages}" style="background: #1a365d; color: #fff;">${pages}</button>`;
    }

    if (page < pages) {
        str += `<button class="btn page-item next" onclick="return false;" data-page="${page + 1}" style="background: #1a365d; color: #fff;">Next</button>`;
    }

    str += "</div>";

    if ($('#pagination').length) {
        $('#pagination').html(str);
    }

    displayRows();
    }


    $(document).on('click', '#pagination button', function(e) {
        e.preventDefault();
        var page = parseInt($(this).data('page'));
        if (page) {
            var table = document.getElementById("table-indexed");
            if (!table) return;
            var rows = table.getElementsByTagName("tr");
            var numRows = rows.length - 1;
            var numPages = Math.ceil(numRows / rowsPerPage);
            createPagination(numPages, page);
        }
    });

    function loadIndexedTable() {
        var $tbody = $('#table-indexed tbody');
        $tbody.html('<tr><td colspan="9">Loading...</td></tr>');

        $.post(chatbotPlugin.ajax_url, {
                action: 'chatbot_get_indexed_table',
                nonce: chatbotPlugin.nonce
            })
            .done(function(response) {
                if (response.success) {
                    if (response.data && response.data.trim().length > 0) {
                        $tbody.html(response.data);
                        ChatbotToast.success('Indexed items loaded successfully');
                        refreshPagination();
                    } else {
                        $tbody.html('<tr><td colspan="9">No indexed items found.</td></tr>');
                        ChatbotToast.warning('No indexed items yet. Start indexing to see items here.');
                    }
                } else {
                    $tbody.html('<tr><td colspan="9">Failed to load.</td></tr>');
                    ChatbotToast.error('Failed to load indexed items');
                }
            })
            .fail(function(xhr, status, error) {
                ChatbotToast.error('Failed to load indexed items');
                console.error('[Table] Load failed:', error);
                $tbody.html('<tr><td colspan="9">AJAX error.</td></tr>');
            });
                      
        $('#search-input').val('').trigger('keyup');

    }

    function addRowToTable(item) {
        var $tbody = $('#table-indexed tbody');
        $tbody.find('tr td[colspan="9"]').closest('tr').remove();

        var newRow = '<tr style="display:none;" class="newly-indexed">' +
            '<td class="text-danger">—</td>' +
            '<td>' + (item.item_id || 'N/A') + '</td>' +
            '<td>' + item.post_id + '</td>' +
            '<td>' + (item.category_id || '—') + '</td>' +
            '<td>' + (item.author || '—') + '</td>' +
            '<td>' + (item.title || 'Untitled') + '</td>' +
            '<td>' + (item.post_name || '—') + '</td>' +
            '<td>' + (item.post_status) + '</td>' +
            '<td>' +
            '<button class="button button-small button-link-delete unindex-item " ' +
            'data-item-id="' + (item.item_id || '') + '" ' +
            'data-category-id="' + (item.category_id || '') + '">' +
            '<span class="dashicons dashicons-trash"></span> UnIndex' +
            '</button>' +
            '</td>' +
            '</tr>';

        $tbody.prepend(newRow);
        $tbody.find('tr.newly-indexed').fadeIn(400, function() {
            $(this).removeClass('newly-indexed');
        });
    }

    $('#search-input').on('keyup', function () {
        var value = $(this).val().toLowerCase().trim();
        var visibleCount = 0;

        $('#table-indexed tbody tr').each(function () {
            var titleText = $(this).find('td:nth-child(6)').text().toLowerCase();

            if (titleText.includes(value)) {
                $(this).show();
                visibleCount++;
            } else {
                $(this).hide();
            }
        });

        if (visibleCount === 0) {
            if ($('#no-search-result').length === 0) {
                $('#table-indexed tbody').append(
                    '<tr id="no-search-result"><td colspan="9" class="text-center text-muted">No matching titles found.</td></tr>'
                );
            }
        } else {
            $('#no-search-result').remove();
        }
    });


    function displayRows() {
        var table = document.getElementById("table-indexed");
        if (!table) return;

        var rows = table.getElementsByTagName("tr");
        var numRows = rows.length - 1; 

        for (var i = 1; i <= numRows; i++) {
            rows[i].style.display = "none";
        }

        var start = (currentPage - 1) * rowsPerPage + 1;
        var end = Math.min(currentPage * rowsPerPage, numRows);

        for (var i = start; i <= end; i++) {
            if (rows[i]) {
                rows[i].style.display = "";
            }
        }
    }

    function refreshPagination() {
        currentPage = 1;
        var table = document.getElementById("table-indexed");
        if (!table) return;

        var rows = table.getElementsByTagName("tr");
        var numRows = rows.length - 1; 
        var numPages = Math.ceil(numRows / rowsPerPage);

        if (numPages > 0) {
            createPagination(numPages, 1);
        } else {
            if ($('#pagination').length) {
                $('#pagination').html('');
            }
        }
    }

    $('#chatbot-index-all-items').on('click', function(e) {
        e.preventDefault();

        var $button = $(this);
        var $resultDiv = $('#chatbot-index-all-result');
        var $progressContainer = $('#progress-container');
        var $progressBar = $('#progress-bar');
        var $progressText = $('#progress-text');

        $button.prop('disabled', true).html('<span class="dashicons dashicons-update spin text-white"></span> <span class="spinner-text text-white">Indexing...</span>');
        $progressContainer.show();
        $resultDiv.html('');

        $.post(chatbotPlugin.ajax_url, {
            action: 'chatbot_index_all_items',
            nonce: chatbotPlugin.nonce
        }).done(function(response) {
            if (response.success) {
                var results = response.data;
                var total = results.length;
                var success = results.filter(r => r.status === 'success').length;
                var already_indexed = results.filter(r => r.status === 'already_indexed').length;
                var failed = results.filter(r => r.status === 'failed').length;
                $progressBar.css('width', '100%');
                $progressText.text('100%');

                var failedItems = results.filter(r => r.status === 'failed');
                if (failedItems.length > 0) {}

                var isManageTabActive = $('.nav-tab[data-tab="manage"]').hasClass('nav-tab-active');

                if (isManageTabActive && success > 0) {
                    var category_id = results.find(r => r.category_id)?.category_id || '';

                    results.forEach(function(item) {
                        if (item.status === 'success' && item.item_id) {
                            addRowToTable({
                                item_id: item.item_id,
                                post_id: item.post_id,
                                category_id: category_id,
                                author: item.author || 'Unknown',
                                title: item.title,
                                post_name: item.post_name || 'untitled',
                                post_status: item.post_status || 'publish'
                            });
                        }
                    });
                    setTimeout(refreshPagination, 500);
                }

                setTimeout(function() {
                    updateCounters();
                }, 500);

                setTimeout(function() {
                    updateCounters();
                }, 1500);

                setTimeout(function() {
                    updateCounters();
                }, 3000);

                var html = '<div style="background:#d4edda; border:1px solid #c3e6cb; padding:15px; border-radius:4px; margin-top:20px;">';
                html += '<h3 style="margin-top:0;color:#155724;"> <i class="fa fa-check-circle text-success"></i> Indexing Complete!</h3>';
                html += '<p><strong>Total:</strong> ' + total + '</p>';
                html += '<p><strong>Success:</strong> <span style="color:#46b450;">' + success + '</span></p>';
                html += '<p><strong>Already Indexed:</strong> <span style="color:#0073aa;">' + already_indexed + '</span></p>';
                html += '<p><strong>Failed:</strong> <span style="color:#dc3232;">' + failed + '</span></p>';
                html += '</div>';

                html += '<details style="margin-top:20px;"><summary style="cursor:pointer;font-weight:bold;">View Details</summary>';
                html += '<table class="wp-list-table widefat fixed striped" style="margin-top:10px;">';
                html += '<thead><tr><th>Post ID</th><th>Title</th><th>Item ID</th><th>Status</th></tr></thead><tbody>';

                results.forEach(function(item) {
                    var statusColor = item.status === 'failed' ? '#dc3232' : (item.status === 'success' ? '#46b450' : '#0073aa');
                    var statusIcon = '';
                    if (item.status === 'failed') {
                        statusIcon = '<i class="fa fa-times-circle text-danger"></i>';
                    } else if (item.status === 'success') {
                        statusIcon = '<i class="fa fa-check-circle text-success"></i>';
                    } else if (item.status === 'already_indexed') {
                        statusIcon = '<i class="fa fa-circle "></i>';
                    } else {
                        statusIcon = '<i class="fa fa-circle-notch fa-spin "></i>';
                    }

                    html += '<tr>';
                    html += '<td>' + item.post_id + '</td>';
                    html += '<td>' + (item.title || 'N/A') + '</td>';
                    html += '<td>' + (item.item_id || 'N/A') + '</td>';
                    html += '<td style="color:' + statusColor + ';font-weight:bold;">' + statusIcon + ' ' + item.status + '</td>';
                    html += '</tr>';
                });

                html += '</tbody></table></details>';
                $resultDiv.html(html);

            } else {
                ChatbotToast.error('Indexing failed.');
            }
        }).fail(function(xhr, status, error) {
            ChatbotToast.error('AJAX request failed.');
        }).always(function() {
            $button.prop('disabled', false).html('<span class="dashicons dashicons-update text-white"></span> Start Indexing');
        });
    });

    $(document).on('click', '.unindex-item', function(e) {
             e.preventDefault();
                var button = $(this);
                var item_id = button.data('item-id');
                var category_id = button.data('category-id');
                var $row = button.closest('tr');

                if (!item_id || !category_id) {
                    alert('Missing item_id or category_id');
                    return;
                }ChatbotModal.confirm(
            'Confirm Unindex',
            'Are you sure you want to unindex this item?',
            function () {

                var originalHtml = button.html();
                button.prop('disabled', true)
                    .html('<span class="dashicons dashicons-update spin"></span> Deleting...');

                $.post(chatbotPlugin.ajax_url, {
                    action: 'chatbot_delete_indexed_item',
                    nonce: chatbotPlugin.nonce,
                    item_id: item_id,
                    category_id: category_id
                })
                .done(function(response) {
                    if (response.success) {
                        ChatbotToast.success(response.data.message || 'Item unindexed successfully');

                        $row.fadeOut(300, function() {
                            $(this).remove();
                            updateCounters();
                            setTimeout(updateCounters, 800);
                            setTimeout(updateCounters, 2000);
                            refreshPagination();

                            var table = document.getElementById("table-indexed");
                            var rowsAfter = table ? table.getElementsByTagName("tr").length - 1 : 0;

                            if (rowsAfter === 0) {
                                $('#table-indexed tbody').html(
                                    '<tr><td colspan="9">No indexed items found.</td></tr>'
                                );
                            }
                        });
                    } else {
                        ChatbotToast.error('Error unindexing item');
                        button.prop('disabled', false).html(originalHtml);
                    }
                })
                .fail(function(xhr, status, error) {
                    console.error('%c[UnIndex] AJAX failed:', 'color: red; font-weight: bold', error);
                    ChatbotToast.error('AJAX request failed');
                    button.prop('disabled', false).html(originalHtml);
                });

            },
            'Unindex',
            'btn-danger'
        );

    });

    $('#chatbot-unindex-all-items').on('click', function() {
        ChatbotModal.confirm(
            'Confirm Unindex',
            'Are you sure you want to unindex all items?',
        function() {
                $('#unindex-item').modal('hide');

                const $result = $('#chatbot-unindex-result');
                $result.html('<i class="fas fa-spinner fa-spin" style="margin-right:5px;"></i> Deleting all items...').show();

                $.post(chatbotPlugin.ajax_url, {
                    action: 'chatbot_unindex_all_items',
                    nonce: chatbotPlugin.nonce
                }, function(response) {
                    if (response.success) {
                        updateCounters();
                        setTimeout(function() {
                            ChatbotToast.success('All items have been unindexed.');
                            $result.text(response.data.message);

                            setTimeout(function() {
                                $result.fadeOut(1000);
                            }, 3000);

                        }, 1500);
                        $('#table-indexed tbody').html('<tr><td colspan="9">No indexed items found.</td></tr>');
                        $('.nav-tab[data-tab="indexing"]').click();
                    } else {
                        ChatbotToast.error('Error deleting all items.');
                        $result.fadeOut(1000);
                    }
                });
            });
            
            'Unindex',
            'btn-danger'
    });

    $(document).on('click', '.submitdelete', function() {
        setTimeout(function() {
            updateCounters();
        }, 2000);
    });

    $(document).on('click', '.btn-index-items', function() {
        $('.nav-tab[data-tab="indexing"]').click();
    });

    $('<style>.spin{animation:spin 1s linear infinite;}@keyframes spin{100%{transform:rotate(360deg);}}</style>').appendTo('head');

    if ($('.notice-success').length > 0) {
        $('.nav-tab[data-tab="indexing"]').click();
    }

    $('.notice-success').delay(3000).fadeOut(1000);
    
    if (document.getElementById("table-indexed")) {
        refreshPagination();
    }
    updateCounters();
   
});
