<?php
/**
 * Plugin Name: Mind Web
 * Description: Plugin that registers your site and enables AI assistant functionality.
 * Version: 1.0
 * Author: Smart Processes
 */

if (!defined('ABSPATH')) exit;

require_once plugin_dir_path(__FILE__) . 'includes/functions.php';
require_once plugin_dir_path(__FILE__) . 'includes/api.php';
require_once plugin_dir_path(__FILE__) . 'includes/sitemap.php';
require_once plugin_dir_path(__FILE__) . 'includes/activation.php';
require_once plugin_dir_path(__FILE__) . 'includes/deactivation.php';
require_once plugin_dir_path(__FILE__) . 'includes/conversations.php';
require_once plugin_dir_path(__FILE__) . 'includes/helpers.php';
require_once plugin_dir_path(__FILE__) . 'public/public.php';
require_once plugin_dir_path(__FILE__) . 'admin/item-settings.php';
require_once plugin_dir_path(__FILE__) . 'admin/stripe-settings.php';
require_once plugin_dir_path(__FILE__) . 'admin/knowledge-repository.php';
require_once plugin_dir_path(__FILE__) . 'admin/admin-conversations.php';
require_once plugin_dir_path(__FILE__) . 'admin/model_usage-settings.php';
require_once plugin_dir_path(__FILE__) . 'includes/components/class-modal.php';
require_once plugin_dir_path(__FILE__) . 'includes/components/class-toast.php';

register_activation_hook(__FILE__, 'chatbot_plugin_activate');

function chatbot_plugin_activate() {
    chatbot_plugin_on_activate();
    chatbot_plugin_set_redirect_flag();
}

register_deactivation_hook(__FILE__, 'chatbot_plugin_deactivate');

function chatbot_plugin_deactivate() {
    chatbot_plugin_on_deactivate();
    chatbot_plugin_cancel_on_deactivate();
}

register_uninstall_hook(__FILE__, 'chatbot_plugin_uninstall');

function chatbot_plugin_uninstall() {
    global $wpdb;
    
    $wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '%chatbot%'");
}

