<?php
if (!defined('ABSPATH')) exit;

    add_action('wp_ajax_chatbot_send_message_stream', 'chatbot_frontend_send_message_stream');
    add_action('wp_ajax_nopriv_chatbot_send_message_stream', 'chatbot_frontend_send_message_stream');
        function chatbot_frontend_send_message_stream() {
            global $wpdb;
            $nonce_value = $_POST['nonce'] ?? '';
            if (!wp_verify_nonce($nonce_value, 'chatbot_frontend_nonce')) {
                wp_send_json_error(['message' => 'Security check failed']);
            }

           if (!session_id()) {
                session_start();
            }

            $session_id = session_id();
            $conversation = $wpdb->get_row(
                $wpdb->prepare(
                    "SELECT * FROM {$wpdb->prefix}chatbot_conversations 
                    WHERE cookie_id = %s 
                    ORDER BY id DESC LIMIT 1",
                    $session_id
                )
            );

            if (!$conversation) {
                $wpdb->insert(
                    "{$wpdb->prefix}chatbot_conversations",
                    [
                        'cookie_id' => $session_id,
                        'ip_address'        => get_client_ipv4(),
                        'screen_resolution' => $_POST['screen_resolution'] ?? '',
                        'user_agent'        => $_SERVER['HTTP_USER_AGENT'] ?? '',
                        'language_accepted' => $_POST['language_accepted'] ?? '',                      
                        'referrer'          => $_SERVER['HTTP_REFERER'] ?? '',
                        'timezone'          => $_POST['timezone'] ?? '',
                        'platform'          => $_POST['platform'] ?? '',
                        'created_at'        => current_time('mysql')
                    ],
                    [
                        '%s','%s','%s','%s','%s','%s','%s','%s','%s'
                    ]
                );
                $conversation_id = $wpdb->insert_id;
            } else {
                $conversation_id = $conversation->id;
            }

            $options = get_option('chatbot_plugin_options', []);
            $base_url = $options['base_url'] ?? '';
            $token = get_option('chatbot_plugin_access_token', '');
            $category = get_option('chatbot_plugin_category', null);
            $app_guid = get_option('chatbot_plugin_guid', '');
            $top_k = intval(get_option('chatbot_ask_setting', 20));

            if (!$category || empty($category['id']) || empty($base_url) || empty($token)) {
                wp_send_json_error(['message' => 'Chatbot configuration missing']);
            }
            
            $question = sanitize_text_field($_POST['message'] ?? '');
            $post_id = intval($_POST['post_id'] ?? 0);

            $table_items = $wpdb->prefix . 'indexed_items';

            $item_id_for_post = $wpdb->get_results(
                $wpdb->prepare("
                    SELECT 
                        item_id,
                        post_id
                    FROM {$table_items} 
                    WHERE post_id = %d
                ", $post_id)
            );

            error_log("post id is: " . $post_id);
            error_log("results: " . print_r($item_id_for_post, true));


            $category_id = intval($category['id']);
            error_log("categoryid is" .$category_id);
            $question_page_based = !empty($category_ids) ? wp_json_encode($category_ids) : '[]';          
           
                $wpdb->insert(
                "{$wpdb->prefix}chatbot_questions",
                [
                    'conversation_id'       => $conversation_id,
                    'question_text'         => $question,
                    'page_id'               => $post_id, 
                    'question_page_based'   => $question_page_based,
                    'created_at'            => current_time('mysql')
                ],
                [
                    '%d',
                    '%s',
                    '%d', 
                    '%s', 
                    '%s'  
                ]
            );

            $question_id = $wpdb->insert_id;

            while (ob_get_level()) ob_end_clean();
            @set_time_limit(0);

            if (function_exists('apache_setenv')) {
                apache_setenv('no-gzip', '1');
            }
            @ini_set('zlib.output_compression', 'Off');
            @ini_set('output_buffering', 0);
            header('Content-Type: text/plain; charset=utf-8');
            header('Cache-Control: no-cache, no-store, must-revalidate');
            header('Pragma: no-cache');
            header('Expires: 0');
            header('Connection: keep-alive');
            header('X-Accel-Buffering: no');

            @ini_set('implicit_flush', '1');
            
            // if (function_exists('apache_setenv')) {
            //     apache_setenv('no-gzip', '1');
            // }
            // while (ob_get_level()) ob_end_flush();
            // ob_implicit_flush(1);

            flush();

            $fullResponse = '';
            $jsonStarted = false;

            $streamCallback = function($ch, $data) use (&$fullResponse, &$jsonStarted) {
                if ($jsonStarted) return strlen($data);

                if (strpos($data, '{"answer"') !== false) {
                    $jsonStarted = true;
                    $parts = explode('{"answer"', $data, 2);
                    $textOnly = $parts[0];

                    echo $textOnly;
                    if (ob_get_level()) ob_flush();
                    flush();
                    $fullResponse .= $textOnly;

                    return strlen($data);
                }

                echo $data;
                if (ob_get_level()) ob_flush();
                flush();
                $fullResponse .= $data;

                return strlen($data);
            };

            $ask_only_current_page = !empty($_POST['ask_only_current_page']); 

            error_log("=== FRONTEND CHECKBOX ===");
            error_log("ask_only_current_page: " . ($ask_only_current_page ? '1' : '0'));
            error_log("Post ID: " . ($_POST['post_id'] ?? 0));
                $category_id = intval($category['id']);
                $notebooks = get_notebooks_for_current_page_or_default($post_id);
                $has_notebooks = !empty($notebooks);

                if ($has_notebooks && $ask_only_current_page) {
                    //  KA space + CHECK
                    $items_ids    = [$post_id];
                    $category_ids = $notebooks;

                } else if ($has_notebooks && !$ask_only_current_page) {

                    // 2) KA space + JO CHECK
                    $items_ids    = [];
                    $category_ids = array_merge([$category_id], $notebooks);

                } else if (!$has_notebooks && $ask_only_current_page) {

                    // SKA space + CHECK
                    $items_ids    = [$post_id];
                    $category_ids = [];

                } else {
                    //  SKA space + JO CHECK
                    $items_ids    = [];
                    $category_ids = [$category_id];
                }

                error_log("=== Check Chat  ===");
                error_log('ASK ONLY PAGE: ' . ($ask_only_current_page ? 'YES' : 'NO'));
                error_log('HAS NOTEBOOKS: ' . ($has_notebooks ? 'YES' : 'NO'));
                error_log('ITEMS IDS: ' . wp_json_encode($items_ids));
                error_log('CATEGORY ID: ' . $category_id);
                error_log('CATEGORY IDS: ' . wp_json_encode($category_ids));

            
           $response = chatbot_ask_page_based(
                $base_url,
                $token,
                $question,
                $category_id,
                $category_ids,
                $top_k,
                $app_guid,
                $streamCallback,
                $items_ids
            );

            error_log("items_ids: " . (!empty($items_ids) ? wp_json_encode($items_ids) : '[]'));
            error_log("category_ids: " . (!empty($category_ids) ? wp_json_encode($category_ids) : '[]'));

            error_log("API response: ".json_encode($response));

            if (!$response['success'] && $response['http_code'] == 401) {
                $newToken = chatbot_refresh_token();
                error_log("New token generated: ".$newToken);
                if ($newToken) {
                    $fullResponse = '';
                    $jsonStarted = false;
                    $response = chatbot_ask_page_based(
                        $base_url,
                        $newToken,
                        $question,
                        $category_id,
                        $category_ids,
                        $top_k,
                        $app_guid,
                        $streamCallback,
                        $items_ids,
                    );
                }
            }

            if (!empty($fullResponse)) {
                $wpdb->insert(
                    "{$wpdb->prefix}chatbot_responses",
                    [
                        'question_id'   => $question_id,
                        'response_text' => $fullResponse,
                        'created_at'    => current_time('mysql')
                    ],
                    [
                        '%d',
                        '%s', 
                        '%s'  
                    ]
                );
                $response_id = $wpdb->insert_id;
            }
            
            exit;
        }

        function get_client_ipv4() {
            $keys = [
                'HTTP_X_FORWARDED_FOR',
                'HTTP_CLIENT_IP',
                'REMOTE_ADDR'
            ];

            foreach ($keys as $key) {
                if (empty($_SERVER[$key])) continue;
                $ips = explode(',', $_SERVER[$key]);
                foreach ($ips as $ip) {
                    $ip = trim($ip);
                    if ($ip === '::1') {
                        return '127.0.0.1';
                    }

                    if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4)) {
                        return $ip;
                    }
                }
            }

            return '';
        }


    function get_notebooks_for_current_page_or_default($post_id) {
        $page_based_notebooks = get_option('chatbot_page_based_notebooks', []);

        if (empty($page_based_notebooks) || !is_array($page_based_notebooks)) {
            error_log("No page-based notebooks configured");
            return [];
        }
        
        $page_title = get_the_title($post_id);
        
        if (empty($page_title)) {
            error_log("No page title found for post_id: " . $post_id);
            return [];
        }

        error_log("Looking for notebooks for page: '{$page_title}' (post_id: {$post_id})");

        foreach ($page_based_notebooks as $item) {

            if (!isset($item['title']) || !isset($item['notebooks'])) {
                error_log("Invalid notebook item structure: " . print_r($item, true));
                continue;
            }

            if (strcasecmp($item['title'], $page_title) === 0) {
                $notebooks = $item['notebooks'];
            
                if (!is_array($notebooks)) {
                    error_log("Notebooks is not an array for page '{$page_title}': " . print_r($notebooks, true));
                    return [];
                }
                
                error_log("Found " . count($notebooks) . " notebook(s) for page '{$page_title}': " . wp_json_encode($notebooks));
                return $notebooks;
            }
        }

        error_log("No matching notebooks found for page: '{$page_title}'");
        return [];
    }




