<?php
if (!defined('ABSPATH')) exit;

class Chatbot_Toast {

    public static function init() {
        add_action('admin_enqueue_scripts', [__CLASS__, 'enqueue_assets']);
        add_action('admin_footer', [__CLASS__, 'render_container']);
    }

    public static function enqueue_assets() {

        // Bootstrap 5 JS (nëse nuk është i ngarkuar)
        wp_enqueue_script(
            'bootstrap-js',
            'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js',
            [],
            '5.3.2',
            true
        );

        // Toast JS
        wp_enqueue_script(
            'chatbot-toast',
            plugin_dir_url(__FILE__) . '../assets/js/Toast.js',
            ['bootstrap-js'],
            '1.0.0',
            true
        );
    }

    public static function render_container() {
    ?>
    <div id="chatbot-toast-container"
         class="toast-container position-fixed top-0 end-0 p-3"
         style="z-index:9999; margin-top: 60px;"></div>
    <style>
        #chatbot-toast-container .toast { min-width: 300px; }
    </style>
    <?php
}
}

Chatbot_Toast::init();
