<?php
if (!defined('ABSPATH')) exit;

add_action('wp_ajax_chatbot_get_conversations_by_date', 'chatbot_get_conversations_by_date_ajax');
function chatbot_get_conversations_by_date_ajax() {
    check_ajax_referer('chatbot_admin_nonce', 'nonce');
    
    global $wpdb;
    
    $start_date = sanitize_text_field($_POST['start_date'] ?? '');
    $end_date = sanitize_text_field($_POST['end_date'] ?? '');
    
    if (empty($start_date) || empty($end_date)) {
        wp_send_json_error('Please provide both start and end dates');
    }

    $start_datetime = $start_date . ' 00:00:00';
    $end_datetime = $end_date . ' 23:59:59';
    $table = $wpdb->prefix . 'chatbot_conversations';

     $conversations = $wpdb->get_results( $wpdb->prepare("
        SELECT 
            c.*,
            COUNT(q.id)        AS total_questions,
            MIN(q.created_at)  AS first_question_at
        FROM {$table} c
        LEFT JOIN {$wpdb->prefix}chatbot_questions q ON q.conversation_id = c.id
        WHERE c.created_at BETWEEN %s AND %s
        GROUP BY c.id
        ORDER BY c.created_at DESC
    ", $start_datetime, $end_datetime));
    
    if (empty($conversations)) {
        wp_send_json_success([
            'conversations' => [],
            'message' => 'No conversations found for this date range'
        ]);
    }
    
    wp_send_json_success([
        'conversations' => $conversations,
        'total' => count($conversations)
    ]);
}

add_action('wp_ajax_chatbot_get_conversations', 'chatbot_get_conversations_ajax');
function chatbot_get_conversations_ajax() {
    check_ajax_referer('chatbot_admin_nonce', 'nonce');
    global $wpdb;
    $conv_id = intval($_POST['conversation_id'] ?? 0);

    if (!$conv_id) {
        wp_send_json_error('Invalid ID');
    }

    $questions = $wpdb->get_results($wpdb->prepare("
        SELECT q.id, q.question_text, q.page_id, q.question_page_based, q.created_at,
               r.response_text, r.created_at AS response_at
        FROM {$wpdb->prefix}chatbot_questions q
        LEFT JOIN {$wpdb->prefix}chatbot_responses r ON r.question_id = q.id
        WHERE q.conversation_id = %d
        ORDER BY q.created_at ASC
    ", $conv_id));

    wp_send_json_success($questions);
}


add_action('wp_ajax_chatbot_get_today_conversations', 'chatbot_get_today_conversations_ajax');
// add_action('wp_ajax_nopriv_chatbot_get_today_conversations', 'chatbot_get_today_conversations_ajax');

function chatbot_get_today_conversations_ajax() {
    check_ajax_referer('chatbot_admin_nonce', 'nonce');

    global $wpdb;

    $start_of_day = date('Y-m-d 00:00:00');
    $end_of_day   = date('Y-m-d 23:59:59');

    $table = $wpdb->prefix . 'chatbot_conversations';

    $conversations = $wpdb->get_results( $wpdb->prepare("
        SELECT 
            c.*,
            COUNT(q.id) AS total_questions,
            MIN(q.created_at) AS first_question_at
        FROM {$table} c
        LEFT JOIN {$wpdb->prefix}chatbot_questions q ON q.conversation_id = c.id
        WHERE c.created_at BETWEEN %s AND %s
        GROUP BY c.id
        ORDER BY c.created_at DESC
    ", $start_of_day, $end_of_day) );

    wp_send_json_success([
        'conversations' => $conversations,
        'total' => count($conversations)
    ]);
}

add_action('wp_ajax_chatbot_delete_conversation', 'chatbot_delete_conversation_ajax');
function chatbot_delete_conversation_ajax() {
    check_ajax_referer('chatbot_admin_nonce', 'nonce');
    global $wpdb;

    $conv_id = intval($_POST['conversation_id'] ?? 0);
    $table = $wpdb->prefix . 'chatbot_conversations';

    if (!$conv_id) {
        wp_send_json_error(['message' => 'Invalid conversation ID']);
    }

    $deleted = $wpdb->delete($table, ['id' => $conv_id], ['%d']);

    if ($deleted === false) {
        wp_send_json_error(['message' => 'Failed to delete conversation']);
    }

    $questions_table = $wpdb->prefix . 'chatbot_questions';
    $responses_table = $wpdb->prefix . 'chatbot_responses';

    $wpdb->delete($questions_table, ['conversation_id' => $conv_id], ['%d']);
    $wpdb->delete($responses_table, ['conversation_id' => $conv_id], ['%d']);

    wp_send_json_success(['message' => 'Conversation deleted successfully']);
}





