<?php
if (!defined('ABSPATH')) exit;

function chatbot_items_table() {
    global $wpdb;

    $table_name = $wpdb->prefix . "indexed_items";
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        item_id bigint(20) NOT NULL,
        post_id bigint(20) NOT NULL,
        category_id bigint(20) NOT NULL,
        created_at datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (id),
        INDEX (post_id)
    ) ENGINE=InnoDB $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);

    if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") === $table_name) {
        error_log("Table $table_name created successfully.");
    } else {
        error_log("Failed to create table $table_name.");
    }
}

function chatbot_create_conversations() {
    global $wpdb;
    $conv_table = $wpdb->prefix . "chatbot_conversations";
    $charset_collate = $wpdb->get_charset_collate();

    $conv_sql = "CREATE TABLE $conv_table (
        id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
        cookie_id VARCHAR(255) NOT NULL,
        ip_address VARCHAR(45) NOT NULL,
        screen_resolution VARCHAR(50),
        user_agent TEXT,
        language_accepted VARCHAR(50),
        referrer TEXT NULL,
        timezone VARCHAR(64) NULL,
        platform VARCHAR(100) NULL,
        created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($conv_sql);

    if ($wpdb->get_var("SHOW TABLES LIKE '$conv_table'") === $conv_table) {
        error_log("Table $conv_table created successfully.");
    } else {
        error_log("Failed to create table $conv_table.");
    }
}

function chatbot_create_questions() {
    global $wpdb;
    $question_table = $wpdb->prefix . "chatbot_questions";
    $charset_collate = $wpdb->get_charset_collate();

    $question_sql = "CREATE TABLE $question_table (
        id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
        conversation_id BIGINT UNSIGNED NOT NULL,
        question_text TEXT NOT NULL,
        page_id VARCHAR(255),
        question_page_based TEXT NULL,
        created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($question_sql);

    if ($wpdb->get_var("SHOW TABLES LIKE '$question_table'") === $question_table) {
        error_log("Table $question_table created successfully.");
    } else {
        error_log("Failed to create table $question_table.");
    }
}


function chatbot_create_responses() {
    global $wpdb;
    $response_table = $wpdb->prefix . "chatbot_responses";
    $charset_collate = $wpdb->get_charset_collate();


    $response_sql = "CREATE TABLE $response_table (
        id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
        question_id BIGINT UNSIGNED NOT NULL,
        response_text TEXT NOT NULL,
        created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($response_sql);

    if ($wpdb->get_var("SHOW TABLES LIKE '$response_table'") === $response_table) {
        error_log("Table $response_table created successfully.");
    } else {
        error_log("Failed to create table $response_table.");
    }
}
