<?php
if (!defined('ABSPATH')) exit;
    require_once dirname(__DIR__) . '/includes/db.php';
    $config_path = dirname(__DIR__) . '/config.json';
    $config = [];

    if (file_exists($config_path)) {
        $config = json_decode(file_get_contents($config_path), true);
    }

    global $stripe_base_url;

   function chatbot_plugin_on_deactivate() {
    global $wpdb;

    $tables = [
        $wpdb->prefix . 'indexed_items',
        $wpdb->prefix . 'chatbot_conversations',
        $wpdb->prefix . 'chatbot_questions',
        $wpdb->prefix . 'chatbot_responses',
    ];

    foreach ($tables as $table) {
        $wpdb->query("DROP TABLE IF EXISTS $table");
        error_log("Dropped table if exists: $table");
    }

    delete_option("my_plugin_db_version");

    error_log("Chatbot Plugin Deactivated and all tables removed.");
}


    function chatbot_plugin_cancel_on_deactivate() {
    global $config; 

        $stripe_base_url = sanitize_text_field(
            $config['stripe_url'] ?? 'https://subscriptions.smartprocesses.cloud/api'
        );
        error_log("chatbot_plugin_cancel_on_deactivate: Stripe Base URL: " . $stripe_base_url);

        $app_guid = get_option('chatbot_plugin_guid');

        if (empty($app_guid)) {
            error_log("chatbot_plugin_cancel_on_deactivate: App GUID is missing.");
            update_option('chatbot_cancel_log', 'App GUID missing on deactivate.');
            return;
        }

        $active_subscription = chatbot_stripe_active_subscription($stripe_base_url, $app_guid);
        error_log("Active subscription fetched: " . print_r($active_subscription, true));

        if (!$active_subscription || empty($active_subscription['stripeSubscriptionId'])) {
            error_log("No active subscription found to cancel on deactivate.");
            update_option('chatbot_cancel_log', 'No active subscription found on deactivate.');
            return;
        }

        $subscription_id = $active_subscription['stripeSubscriptionId'];

        $response = chatbot_plugin_cancel_subscription($stripe_base_url, $app_guid, $subscription_id, true);
        error_log("Cancel subscription response: " . print_r($response, true));

        if (isset($response['error'])) {
            $message = "Error cancelling subscription on deactivate: " . $response['error'];
            error_log($message);
            update_option('chatbot_cancel_log', $message);
        } else {
            $message = "Subscription cancelled successfully on deactivate. Subscription ID: " . $subscription_id;
            error_log($message);
            update_option('chatbot_cancel_log', $message);
        }
    }
