<?php
if (!defined('ABSPATH')) exit;


require_once plugin_dir_path(__FILE__) . 'ask_stream.php';

require_once plugin_dir_path(__FILE__) . 'session.php';

require_once plugin_dir_path(__FILE__) . 'ajax.php';

require_once plugin_dir_path(__FILE__) . 'api.php';

require_once plugin_dir_path(__FILE__) . 'hooks.php';

require_once plugin_dir_path(__FILE__) . 'stripe.php';

require_once plugin_dir_path(__FILE__) . 'knowledge_repository.php';


function enqueue_chatbot_helpers_js() {
    // Path to your JS file
    $js_path = plugin_dir_url(__DIR__) . 'assets/js/conversations.js';

    // Enqueue the script
    wp_enqueue_script(
        'chatbot-helpers', // handle
        $js_path,          // file path
        ['jquery'],        // dependencies
        '1.0.0',           // version
        true               // load in footer
    );

    wp_localize_script('chatbot-helpers', 'chatbotData', [
        'ajaxurl' => admin_url('admin-ajax.php'),
        'nonce'   => wp_create_nonce('chatbot_nonce')
    ]);
}
add_action('wp_enqueue_scripts', 'enqueue_chatbot_helpers_js');
