<?php
if (!defined('ABSPATH')) exit;

    function chatbot_has_indexed_items() {
        global $wpdb;
        static $cached_result = null;
        
        if ($cached_result !== null) {
            return $cached_result;
        }
        
        $count = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}indexed_items LIMIT 1");
        $cached_result = ($count > 0);
        
        return $cached_result;
    }

    add_action('wp_footer', 'chatbot_add_floating_icon');
        function chatbot_add_floating_icon() {
        if (!chatbot_has_indexed_items()) {
            return;
        }
        
        $trial_response = get_option('chatbot_trial_response', []);
        $endDate = $trial_response['currentPeriodEnd'] ?? '';
        $status = $trial_response['status'] ?? '';
        $bg_color   = get_theme_mod('background_color', 'ffffff'); 
        $text_color = get_theme_mod('text_color', '000000');

        if ($endDate) {
            try {
                $now = new DateTime('now', new DateTimeZone('UTC'));
                $end = new DateTime($endDate, new DateTimeZone('UTC'));
                $status_int = intval($status);
                
                if ($now > $end || ($status_int !== 0 && $status_int !== 1)) {
                    return;
                }
            } catch (Exception $e) {
                error_log('[CHATBOT] Error checking trial: ' . $e->getMessage());
                return;
            }
        }
        
        $plugin_url = plugin_dir_url(dirname(__FILE__));
        $img_url = $plugin_url . 'assets/img/logo_notespace_smart.png';

        $site_icon_url = get_site_icon_url();
        error_log("Site icon URL: " . $site_icon_url);
        if(!$site_icon_url || empty($site_icon_url)) {
            $site_icon_url = $img_url;
        }
        ?>
            <div id="chatbot-btn-wrapper" class="chatbot-trigger-container">
                <button class="chatbot-trigger-btn" id="open-chatbot">
                    <img src="<?php echo esc_url($site_icon_url); ?>" alt="Site Icon" class="rounded-circle">
                </button>
            </div>
            <div id="mindweb-chatbot-root">
                <div id="chatbot-container" class="chatbot-container" style="display: none;">
                    <div class="chatbot-header">
                        <div class="chatbot-header-content" style="display: flex; align-items: center;">
                            <img src="<?php echo esc_url($site_icon_url); ?>" alt="Site Icon" class="rounded-circle" style="margin-right:10px;">
                            <div class="header-status">
                                <div class="web-assist-header" style="display: flex; align-items: baseline; gap: 5px;">
                                    <span style="font-size: 18px; font-weight: bold;">Mind Web</span>
                                    <i style="margin-top: 4px;">Concierge</i>
                                    
                                </div>
                                <div class="status-indicator" style="margin-left: 8px;">
                                    <span class="status-dot"></span>
                                </div>
                            </div> 
                        </div>
                        <div class="chatbot-header-actions d-flex align-items-center" style="gap:5px;">
                            <button id="chatbot-theme-toggle" class="chatbot-theme-toggle" title="Toggle dark/light mode">
                                 <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                                    <path d="M8 4.5a3.5 3.5 0 1 0 0 7 3.5 3.5 0 0 0 0-7zM8 0a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-1 0v-1A.5.5 0 0 1 8 0zm0 14a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-1 0v-1a.5.5 0 0 1 .5-.5zm8-6a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1 0-1h1a.5.5 0 0 1 .5.5zm-14 0a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1 0-1h1a.5.5 0 0 1 .5.5zm10.657-5.657a.5.5 0 0 1 0 .707l-.708.708a.5.5 0 1 1-.707-.707l.708-.708a.5.5 0 0 1 .707 0zm-9.9 9.9a.5.5 0 0 1 0 .707l-.708.708a.5.5 0 0 1-.707-.707l.708-.708a.5.5 0 0 1 .707 0zm9.9 0a.5.5 0 0 1 .707 0l.708.708a.5.5 0 0 1-.707.707l-.708-.708a.5.5 0 0 1 0-.707zm-9.9-9.9a.5.5 0 0 1 .707 0l.708.708a.5.5 0 0 1-.707.707l-.708-.708a.5.5 0 0 1 0-.707z"/>
                                </svg>
                            </button>
                            <button id="clear-chat-history" class="clear-chat-history" title="Start new conversation">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                                    <path d="M3 9.5a1.5 1.5 0 1 1 0-3 1.5 1.5 0 0 1 0 3zm5 0a1.5 1.5 0 1 1 0-3 1.5 1.5 0 0 1 0 3zm5 0a1.5 1.5 0 1 1 0-3 1.5 1.5 0 0 1 0 3z"/>
                                </svg>
                            </button>
                            <button id="resize-chatbot" class="chatbot-resize" title="Resize window">
                                <svg xmlns="http://www.w3.org/2000/svg" width="64px" height="64px" viewBox="-16 -16 64.00 64.00" style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2;">
                                    <path d="M7.539,26.475l6.849,-6.971c0.58,-0.591 0.572,-1.541 -0.019,-2.121c-0.591,-0.58 -1.541,-0.572 -2.121,0.019l-6.737,6.856c-0.007,-0.079 -0.011,-0.159 -0.011,-0.24c0,-0 -0,-7.018 -0,-7.018c-0,-0.828 -0.672,-1.5 -1.5,-1.5c-0.828,0 -1.5,0.672 -1.5,1.5l0,7.018c0,3.037 2.462,5.5 5.5,5.5c3.112,-0 6.905,-0 6.905,-0c0.828,-0 1.5,-0.673 1.5,-1.5c0,-0.828 -0.672,-1.5 -1.5,-1.5l-6.905,-0c-0.157,-0 -0.311,-0.015 -0.461,-0.043Z"/>
                                    <path d="M24.267,5.51l-7.056,7.181c-0.58,0.591 -0.571,1.541 0.019,2.122c0.591,0.58 1.541,0.571 2.121,-0.019l7.149,-7.277c0.031,0.156 0.047,0.318 0.047,0.483c-0,0 -0,6.977 -0,6.977c-0,0.828 0.672,1.5 1.5,1.5c0.828,0 1.5,-0.672 1.5,-1.5l-0,-6.977c-0,-3.038 -2.463,-5.5 -5.5,-5.5c-3.162,0 -7.047,0 -7.047,0c-0.828,0 -1.5,0.672 -1.5,1.5c0,0.828 0.672,1.5 1.5,1.5c0,0 3.885,0 7.047,0c0.074,-0 0.147,0.003 0.22,0.01Z"/>
                                </svg>
                            </button>
                            <button class="chatbot-close" id="close-chatbot" title="Close chat">
                               <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                                <path d="M4 8a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7A.5.5 0 0 1 4 8z"/>
                            </svg>
                            </button>
                        </div>
                    </div>
                    <div class="chatbot-messages" id="chatbot-messages"></div>
                    <div class="chatbot-typing" id="chatbot-typing" style="display: none;">
                        <div class="typing-indicator">
                            <span></span>
                            <span></span>
                            <span></span>
                        </div>
                    </div>
                    <div class="chatbot-input-container">
                        <div class="chatbot-checkbox-wrapper">
                            <label>
                                <input type="checkbox" id="chatbot-context-toggle"> 
                                <span class="ask-label-name"> Local Thinking</span>
                                    <span class="tooltip-container"> 
                                        <button type="button" aria-label="more info">?</button> 
                                        <span role="status">Mind Web will focus only on information available on this page to provide contextual answers.</span>
                                    </span>
                            </label>
                        </div>
                
                        <div class="chatbot-input-wrapper">
                            <textarea 
                                id="chatbot-input" 
                                class="chatbot-input chatbot-textarea" 
                                placeholder="Type your message here..."
                                rows="1"></textarea>

                            <button class="chatbot-send-btn" id="chatbot-send" title="Send message">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M14.536 21.686a.5.5 0 0 0 .937-.024l6.5-19a.496.496 0 0 0-.635-.635l-19 6.5a.5.5 0 0 0-.024.937l7.93 3.18a2 2 0 0 1 1.112 1.11z"></path>
                                    <path d="m21.854 2.147-10.94 10.939"></path>
                                </svg>
                            </button>
                        </div>
                    </div>
                    <div class="chatbot-footer gap-2" id="chatbot-footer">
                        <span class="powered-by">Powered by:</span>
                        <a href="https://www.aisystems.it/mind-web/" target="_blank" class="powered-link">
                            AIsystems.it
                        </a>
                    </div>
                    <div class="modal fade" id="startNewChatModal" tabindex="-1" aria-labelledby="startNewChatModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header border-0 pb-0">
                                <h5 class="modal-title fw-semibold" id="startNewChatModalLabel">
                                    <i class="bi bi-chat-dots me-2"></i>Start a New Chat
                                </h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                        <path d="M.293.293a1 1 0 0 1 1.414 0L8 6.586 14.293.293a1 1 0 1 1 1.414 1.414L9.414 8l6.293 6.293a1 1 0 0 1-1.414 1.414L8 9.414l-6.293 6.293a1 1 0 0 1-1.414-1.414L6.586 8 .293 1.707a1 1 0 0 1 0-1.414z"/>
                                    </svg>
                                </button>
                            </div>
                            <div class="modal-body pt-2">
                                <p class="text-muted mb-0">
                                    Starting a new conversation will clear your current chat history. 
                                    This action cannot be undone.
                                </p>
                            </div>
                            <div class="modal-footer border-0 pt-0">
                                <button type="button" id="confirmNewChatBtn" class="btn" style="min-width: 100px !important;">
                                    Start New Chat
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                </div>

                
            </div>
        <?php
    }


    add_action('wp_enqueue_scripts', 'chatbot_enqueue_scripts');
        function chatbot_enqueue_scripts() {

        if (!chatbot_has_indexed_items()) {
            return; 
        }

        wp_enqueue_script('jquery');
        wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css', [], '5.4.0');
        wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js', ['jquery'], '5.4.0', true);
        wp_enqueue_script('jquery');

        wp_enqueue_script(
            'chatbot-frontend',
            plugin_dir_url(__DIR__) . 'assets/js/chatbot-frontend.js',
            ['jquery','bootstrap-js'],
            '3.9.0', 
            true
        );

        wp_enqueue_style(
            'chatbot-mind-web-style',
            plugin_dir_url(__DIR__) . 'assets/css/mind_web.css',
            [],
            '4.2.0'
        );

        wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css');

        $chat_history = $_SESSION['chat_history'] ?? [];
        $site_icon_url = get_site_icon_url();
        $plugin_url = plugin_dir_url(dirname(__FILE__));
        $img_url = $plugin_url . 'assets/img/logo_notespace_smart.png';
        
        $site_icon_url = get_site_icon_url();
        if (empty($site_icon_url)) {
            $site_icon_url = $img_url;
        }
        $user_avatar = get_avatar_url(get_current_user_id(), ['size' => 64]);
        $summary = get_option('chatbot_summary');

        wp_localize_script('chatbot-frontend', 'chatbotFrontend', [
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('chatbot_frontend_nonce'),
            'post_id' => get_the_ID(),
            'initialHistory' => $chat_history,
            'bot_avatar' => $site_icon_url ?? $img_url,
            'user_avatar' => $user_avatar,
            'summary' => $summary,
        ]);

        $trial_response = get_option('chatbot_trial_response', []);
        $endDate = $trial_response['currentPeriodEnd'] ?? '';
        $status = $trial_response['status'] ?? '';
        $type = $trial_response['type'] ?? '';
        $stripe_base_url = get_option('chatbot_stripe_base_url', '');
        $app_guid = get_option('chatbot_plugin_guid', '');
        $product_id = get_option('chatbot_stripe_product_id','');
        $user_email = wp_get_current_user()->user_email;

        wp_localize_script('chatbot-frontend', 'chatbotData', [
            'ajaxurl' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('chatbot_trial_nonce'),
            'trialEndDate' => $endDate,
            'stripe_base_url' => $stripe_base_url,
            'app_guid' => $app_guid,
            'product_id' => $product_id,
            'trial_status' => $status,
            'trial_type' => $type,
            'user_email' => $user_email,
            'should_show_initially' => true
        ]);  
    }

    add_action('transition_post_status', 'chatbot_clear_items_cache', 10, 3);
        function chatbot_clear_items_cache($new_status, $old_status, $post) {
        if (!in_array($post->post_type, ['post','page'])) return;
        
        global $wpdb;
        $cache_key = 'chatbot_has_items_' . get_current_blog_id();
        wp_cache_delete($cache_key, 'chatbot');
    }

    add_action('before_delete_post', 'chatbot_clear_cache_on_delete');
        function chatbot_clear_cache_on_delete($post_id) {
        $post = get_post($post_id);
        if (!$post || !in_array($post->post_type, ['post','page'])) return;
        
        $cache_key = 'chatbot_has_items_' . get_current_blog_id();
        wp_cache_delete($cache_key, 'chatbot');
    }

    add_action('transition_post_status', 'chatbot_handle_status_change', 10, 3);
        function chatbot_handle_status_change($new_status, $old_status, $post) {
        if (!in_array($post->post_type, ['post','page'])) return;

        global $wpdb;
        $post_id = $post->ID;

        error_log("[CHATBOT] Status transition for post_id {$post_id}: {$old_status} -> {$new_status}");

        $options = get_option('chatbot_plugin_options', []);
        $base_url = $options['base_url'] ?? '';
        $token = get_option('chatbot_plugin_access_token', '');
        $category = get_option('chatbot_plugin_category', []);
        $category_id = isset($category['id']) ? intval($category['id']) : null;

        if ($new_status === 'publish' && $old_status !== 'publish') {
            error_log("[CHATBOT] Post {$post_id} published, checking if needs indexing...");

            if (!$base_url || !$token || !$category_id) {
                error_log("[CHATBOT] Skipped indexing: missing Base URL, Token or Category ID for post {$post_id}");
                return;
            }

            $existing = $wpdb->get_row($wpdb->prepare(
                "SELECT item_id, category_id FROM {$wpdb->prefix}indexed_items WHERE post_id = %d LIMIT 1",
                $post_id
            ));

            if ($existing && $existing->category_id == $category_id) {
                error_log("[CHATBOT] Post {$post_id} is already indexed with item_id {$existing->item_id}, skipping API call");
                return; 
            }

            error_log("[CHATBOT] Post {$post_id} not indexed, proceeding with API call...");
            
            $post_categories = wp_get_post_categories($post->ID, ['fields' => 'names']);
            $post_tags = wp_get_post_tags($post->ID, ['fields' => 'names']);

            $rest_url = rest_url('wp/v2/' . $post->post_type . 's/' . $post->ID);
            $response = wp_remote_get($rest_url);
            
            if (is_wp_error($response)) {
                error_log('[CHATBOT] Failed to fetch REST API data for post ' . $post->ID);
                $wp_json = [];
            } else {
                $wp_json = json_decode(wp_remote_retrieve_body($response), true);
            }

            $meta = [
                'categories' => $post_categories,
                'tags' => $post_tags
            ];

            $chunk_size = $options['chunk_size'] ?? 1000;
            $chunk_overlap = $options['chunk_overlap'] ?? 200;
            $header_levels = $options['header_levels'] ?? 'h1';
            error_log("Chunk size debug" .$chunk_size);
            error_log("Chunk overlap debug" .$chunk_overlap);

            $api_response = chatbot_plugin_api_index_items(
                $base_url,
                $token,
                $category_id,
                $chunk_size,
                $chunk_overlap,
                get_permalink($post_id),
                $wp_json,
                $header_levels,
                $meta
            );

            $success = $api_response['success'] ?? false;
            $http_code = $api_response['http_code'] ?? 0;

            if (!$success && $http_code == 401) {
                error_log("[CHATBOT] ACCESS TOKEN EXPIRED. REFRESHING...");
                $new_token = chatbot_refresh_token();
                if ($new_token) {
                    $api_response = chatbot_plugin_api_index_items(
                        $base_url,
                        $new_token,
                        $category_id,
                        $chunk_size,
                        $chunk_overlap,
                        get_permalink($post_id),
                        $wp_json,
                        $header_levels,
                        $meta
                    );
                }
            }

            $new_item_id = $api_response['item_id'] ?? null;
            if (!$new_item_id) {
                error_log("[CHATBOT] Indexing failed for post_id {$post_id}");
                return;
            }

            if ($existing) {
                $wpdb->update(
                    $wpdb->prefix . 'indexed_items',
                    [
                        'item_id' => $new_item_id,
                        'category_id' => $category_id,
                        'created_at' => current_time('mysql')
                    ],
                    ['post_id' => $post_id],
                    ['%s','%d','%s'],
                    ['%d']
                );
                error_log("[CHATBOT] Updated post_id {$post_id} in index with item_id {$new_item_id}");
            } else {
                $wpdb->insert(
                    $wpdb->prefix . 'indexed_items',
                    [
                        'post_id' => $post_id,
                        'item_id' => $new_item_id,
                        'category_id' => $category_id,
                        'created_at' => current_time('mysql')
                    ],
                    ['%d','%s','%d','%s']
                );
                error_log("[CHATBOT] Indexed post_id {$post_id} with item_id {$new_item_id}");
            }
        }
    }

    add_action('before_delete_post', 'chatbot_handle_post_delete', 10, 1);
        function chatbot_handle_post_delete($post_id) {
        $post = get_post($post_id);
        if (!$post || !in_array($post->post_type, ['post','page'])) return;

        error_log("[CHATBOT] Post {$post_id} is being deleted, removing from index");
        
        global $wpdb;
        
        $indexed_item = $wpdb->get_row($wpdb->prepare(
            "SELECT item_id, category_id FROM {$wpdb->prefix}indexed_items WHERE post_id = %d LIMIT 1",
            $post_id
        ));
        
        if (!$indexed_item) {
            error_log("[CHATBOT] Post {$post_id} was not indexed, nothing to delete");
            return;
        }
        $options = get_option('chatbot_plugin_options', []);
        $base_url = $options['base_url'] ?? '';
        $token = get_option('chatbot_plugin_access_token', '');
        
        if ($base_url && $token && $indexed_item->item_id && $indexed_item->category_id) {
            $api_response = chatbot_plugin_api_delete_indexed_items(
                $base_url, 
                $token, 
                $indexed_item->category_id, 
                $indexed_item->item_id
            );
            
            if (!$api_response['success'] && $api_response['http_code'] == 401) {
                error_log("[CHATBOT] Token expired, refreshing...");
                $new_token = chatbot_refresh_token();
                if ($new_token) {
                    $api_response = chatbot_plugin_api_delete_indexed_items(
                        $base_url, 
                        $new_token, 
                        $indexed_item->category_id, 
                        $indexed_item->item_id
                    );
                }
            }
            
            if ($api_response['success']) {
                error_log("[CHATBOT] Successfully removed post {$post_id} from API index");
            } else {
                error_log("[CHATBOT] Failed to remove post {$post_id} from API: " . ($api_response['error'] ?? 'Unknown error'));
            }
        }
        
        $deleted = $wpdb->delete(
            $wpdb->prefix . 'indexed_items',
            ['post_id' => $post_id],
            ['%d']
        );
        
        if ($deleted) {
            error_log("[CHATBOT] Removed post {$post_id} from local database");
            
            $cache_key = 'chatbot_has_items_' . get_current_blog_id();
            wp_cache_delete($cache_key, 'chatbot');
        } else {
            error_log("[CHATBOT] Failed to remove post {$post_id} from local database");
        }
    }
    add_action('wp_trash_post', 'chatbot_handle_post_trash', 10, 1);
        function chatbot_handle_post_trash($post_id) {
        $post = get_post($post_id);
        if (!$post || !in_array($post->post_type, ['post','page'])) return;
        
        error_log("[CHATBOT] Post {$post_id} moved to trash, removing from index");
        chatbot_handle_post_delete($post_id);
    }
