<?php
if (!defined('ABSPATH')) exit;

error_log("=== HISTORY FILE LOADED ===");

add_action('wp_ajax_chatbot_get_history', 'chatbot_get_history_ajax');
add_action('wp_ajax_nopriv_chatbot_get_history', 'chatbot_get_history_ajax');

function chatbot_get_history_ajax() {
    global $wpdb;

    if (!session_id()) {
        session_start();
    }
    $session_id = session_id();
    
    error_log("=== GETTING HISTORY ===");
    error_log("Session ID: " . $session_id);
    
    $post_id = isset($_GET['post_id']) ? intval($_GET['post_id']) : 0;
    error_log("Requested post_id: " . $post_id);

    $conversation = $wpdb->get_row(
        $wpdb->prepare(
            "SELECT * FROM {$wpdb->prefix}chatbot_conversations WHERE cookie_id = %s ORDER BY id DESC LIMIT 1",
            $session_id
        )
    );
    
    if (!$conversation) {
        error_log("No conversation found for session: " . $session_id);
        wp_send_json_success([]);
        return;
    }
    
    error_log("Conversation ID: " . $conversation->id);

    $results = $wpdb->get_results(
        $wpdb->prepare(
            "SELECT q.id AS question_id, q.question_text, q.created_at AS question_time, q.page_id,
                    r.id AS response_id, r.response_text, r.created_at AS response_time
             FROM {$wpdb->prefix}chatbot_questions q
             LEFT JOIN {$wpdb->prefix}chatbot_responses r ON q.id = r.question_id
             WHERE q.conversation_id = %d
             ORDER BY q.created_at ASC",
            $conversation->id
        ),
        ARRAY_A
    );

    error_log("Total history items found: " . count($results));

    $formatted_history = [];
    
    foreach ($results as $row) {
        if (!empty($row['question_text'])) {
            $formatted_history[] = [
                'role' => 'user',
                'message' => $row['question_text'],
                'timestamp' => $row['question_time'],
                'page_id' => $row['page_id']
            ];
        }
        
        if (!empty($row['response_text'])) {
            $formatted_history[] = [
                'role' => 'bot',
                'message' => $row['response_text'],
                'timestamp' => $row['response_time'],
                'page_id' => $row['page_id']
            ];
        }
    }

    error_log("Formatted history count: " . count($formatted_history));
    error_log("=== END GETTING HISTORY ===");
    
    wp_send_json_success($formatted_history);
}

function chatbot_clear_history() {
    global $wpdb;

    $nonce_value = $_POST['nonce'] ?? '';
    if (!wp_verify_nonce($nonce_value, 'chatbot_frontend_nonce')) {
        error_log("Start/Get chat - Nonce verification failed");
        wp_send_json_error(['message' => 'Security check failed']);
        return;
    }

    if (!session_id()) session_start();
    $session_id = session_id();

    $conversation = $wpdb->get_row(
        $wpdb->prepare(
            "SELECT * FROM {$wpdb->prefix}chatbot_conversations 
             WHERE cookie_id = %s 
             ORDER BY id DESC LIMIT 1",
            $session_id
        )
    );

    if ($conversation) {
        $conversation_id = $conversation->id;
        error_log("Using existing conversation ID: " . $conversation_id);
    } else {
        $screen_resolution = $_POST['screen_resolution'] ?? '';
        $ip_address = $_SERVER['REMOTE_ADDR'] ?? '';
        $browser_info = $_SERVER['HTTP_USER_AGENT'] ?? '';
        $language_accepted = $_POST['language_accepted'] ?? '';

        $wpdb->insert(
            "{$wpdb->prefix}chatbot_conversations",
            [
                'cookie_id' => $session_id,
                'ip_address' => $ip_address,
                'screen_resolution' => $screen_resolution,
                'browser_info' => $browser_info,
                'language_accepted' => $language_accepted,
                'created_at' => current_time('mysql')
            ],
            [
                '%s','%s','%s','%s','%s'
            ]
        );

        $conversation_id = $wpdb->insert_id;
        error_log("Created new conversation ID: " . $conversation_id);
    }

    wp_send_json_success([
        'message' => 'Conversation ready',
        'conversation_id' => $conversation_id
    ]);
}


add_action('wp_ajax_chatbot_clear_history', 'chatbot_clear_history');
add_action('wp_ajax_nopriv_chatbot_clear_history', 'chatbot_clear_history');