<?php
if (!defined('ABSPATH')) exit;


add_action('init', function() {
    if (isset($_GET['chatbot_sitemap']) && $_GET['chatbot_sitemap'] === '1') {
        header('Content-Type: application/xml; charset=utf-8');
        echo chatbot_get_sitemap_xml();
        exit;
    }
});


function chatbot_get_sitemap_xml() {
    $sitemap  = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    $sitemap .= "<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n";
    
    $sitemap .= "    <url>\n";
    $sitemap .= "        <loc>" . esc_url(home_url('/')) . "</loc>\n";
    $sitemap .= "        <lastmod>" . date('c') . "</lastmod>\n";
    $sitemap .= "        <changefreq>daily</changefreq>\n";
    $sitemap .= "        <priority>1.0</priority>\n";
    $sitemap .= "    </url>\n";

    $menu_items = chatbot_get_all_menu_items();
    
    if (!empty($menu_items)) {
        $sitemap .= chatbot_render_pages_xml($menu_items);
    }

    $sitemap .= "</urlset>";

    return $sitemap;
}

function chatbot_get_all_menu_items() {
    $all_items = [];
    
    $locations = get_nav_menu_locations();
    
    if (empty($locations)) {
        error_log('Chatbot: No menu locations registered!');
        
        $menus = wp_get_nav_menus();
        foreach ($menus as $menu) {
            $menu_items = wp_get_nav_menu_items($menu->term_id);
            if ($menu_items) {
                foreach ($menu_items as $item) {
                    $url = $item->url;
                    
                    if (strpos($url, home_url()) === false) {
                        continue;
                    }
                    
                    if (!isset($all_items[$url])) {
                        $all_items[$url] = [
                            'url'      => $url,
                            'lastmod'  => $item->object_id 
                                ? get_post_modified_time('c', true, $item->object_id)
                                : date('c'),
                            'title'    => $item->title,
                            'priority' => 0.8
                        ];
                    }
                }
            }
        }
        
        return array_values($all_items);
    }
    
    foreach ($locations as $location => $menu_id) {
        if (!$menu_id) continue;
        
        $menu_items = wp_get_nav_menu_items($menu_id);
        
        if (!$menu_items) continue;
        
        foreach ($menu_items as $item) {
            $url = $item->url;
            
            if (strpos($url, home_url()) === false) {
                continue;
            }
            
            if (!isset($all_items[$url])) {
                $all_items[$url] = [
                    'url'      => $url,
                    'lastmod'  => $item->object_id 
                        ? get_post_modified_time('c', true, $item->object_id)
                        : date('c'),
                    'title'    => $item->title,
                    'priority' => 0.8
                ];
            }
        }
    }
    
    return array_values($all_items);
}

function chatbot_render_pages_xml($pages) {
    $xml = '';
    
    foreach ($pages as $page) {
        $xml .= "    <url>\n";
        $xml .= "        <loc>" . esc_url($page['url']) . "</loc>\n";
        $xml .= "        <lastmod>" . $page['lastmod'] . "</lastmod>\n";
        $xml .= "        <changefreq>monthly</changefreq>\n";
        $xml .= "        <priority>" . $page['priority'] . "</priority>\n";
        $xml .= "    </url>\n";
    }
    
    return $xml;
}